/*
 * Decompiled with CFR 0.152.
 */
package in.clouthink.daas.fss.webdav.impl;

import com.github.sardine.DavResource;
import com.github.sardine.Sardine;
import com.github.sardine.SardineFactory;
import com.github.sardine.impl.SardineImpl;
import com.github.sardine.util.SardineUtil;
import in.clouthink.daas.fss.core.FileStorage;
import in.clouthink.daas.fss.core.StoreFileException;
import in.clouthink.daas.fss.core.StoreFileRequest;
import in.clouthink.daas.fss.core.StoreFileResponse;
import in.clouthink.daas.fss.core.StoredFileObject;
import in.clouthink.daas.fss.support.DefaultStoreFileResponse;
import in.clouthink.daas.fss.util.MetadataUtils;
import in.clouthink.daas.fss.webdav.exception.WebDavStoreException;
import in.clouthink.daas.fss.webdav.impl.DefaultStoredFileObject;
import in.clouthink.daas.fss.webdav.impl.WebDavFile;
import in.clouthink.daas.fss.webdav.support.WebDavProperties;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.conn.ssl.TrustStrategy;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class FileStorageImpl
implements FileStorage,
InitializingBean {
    private static final Log logger = LogFactory.getLog(FileStorageImpl.class);
    public static final String PROVIDER_NAME = "webdav";
    @Autowired
    private WebDavProperties webDavProperties;
    private Sardine sardine;

    public WebDavProperties getWebDavProperties() {
        return this.webDavProperties;
    }

    public Sardine getSardine() {
        return this.sardine;
    }

    public String getName() {
        return PROVIDER_NAME;
    }

    public boolean isMetadataSupported() {
        return true;
    }

    public StoreFileResponse store(InputStream inputStream, StoreFileRequest request) throws StoreFileException {
        String filenameToSave = MetadataUtils.generateFilename((StoreFileRequest)request);
        String uploadEndpoint = this.webDavProperties.getEndpoint();
        if (!uploadEndpoint.endsWith("/")) {
            uploadEndpoint = uploadEndpoint.concat("/");
        }
        try {
            String directory = this.createDirectory(uploadEndpoint);
            filenameToSave = directory.concat("/").concat(filenameToSave);
        }
        catch (Throwable e) {
            logger.error((Object)String.format("Fail to create path %s", uploadEndpoint), e);
        }
        String remoteFilename = uploadEndpoint.concat(filenameToSave);
        try {
            this.sardine.put(remoteFilename, inputStream, request.getContentType());
            logger.debug((Object)String.format("%s is stored to %s", request.getOriginalFilename(), remoteFilename));
        }
        catch (Throwable e) {
            throw new WebDavStoreException(String.format("Fail to upload file %s", remoteFilename), e);
        }
        Map metadata = MetadataUtils.buildMetadata((StoreFileRequest)request);
        try {
            this.sardine.patch(remoteFilename, SardineUtil.toQName((Map)metadata));
            logger.debug((Object)String.format("Metadata for %s is stored", remoteFilename));
        }
        catch (Throwable e) {
            logger.error((Object)"Fail to set webdav metadata", e);
        }
        DefaultStoredFileObject fileObject = DefaultStoredFileObject.from(request);
        fileObject.setUploadedAt(new Date());
        fileObject.setStoredFilename(filenameToSave);
        fileObject.setFileUrl(remoteFilename);
        fileObject.setProviderName(PROVIDER_NAME);
        fileObject.setImplementation(new WebDavFile(remoteFilename, this.sardine));
        return new DefaultStoreFileResponse(PROVIDER_NAME, (StoredFileObject)fileObject);
    }

    public StoreFileResponse store(File file, StoreFileRequest request) throws StoreFileException {
        try {
            return this.store(new FileInputStream(file), request);
        }
        catch (FileNotFoundException e) {
            throw new WebDavStoreException(file.getName() + " not found.", e);
        }
    }

    public StoreFileResponse store(byte[] bytes, StoreFileRequest request) throws StoreFileException {
        return this.store(new ByteArrayInputStream(bytes), request);
    }

    public StoredFileObject findByStoredFilename(String filename) {
        String uploadEndpoint;
        if (StringUtils.isEmpty((Object)filename)) {
            return null;
        }
        if (filename.indexOf("?") > 0) {
            filename = filename.substring(0, filename.indexOf("?"));
        }
        if (!(uploadEndpoint = this.webDavProperties.getEndpoint()).endsWith("/")) {
            uploadEndpoint = uploadEndpoint.concat("/");
        }
        String remoteFilename = uploadEndpoint.concat(filename);
        try {
            if (!this.sardine.exists(remoteFilename)) {
                return null;
            }
        }
        catch (IOException e) {
            logger.error((Object)String.format("Fail to get file %s", filename));
            return null;
        }
        DefaultStoredFileObject fileObject = new DefaultStoredFileObject();
        try {
            List davResources = this.sardine.list(remoteFilename);
            if (davResources != null && davResources.size() == 1) {
                DavResource davResource = (DavResource)davResources.get(0);
                this.buildStoreFileObject(davResource, fileObject);
            }
        }
        catch (IOException e) {
            logger.error((Object)String.format("Fail to resolve metadata of %s", remoteFilename), (Throwable)e);
        }
        fileObject.setStoredFilename(filename);
        fileObject.setProviderName(PROVIDER_NAME);
        fileObject.setImplementation(new WebDavFile(remoteFilename, this.sardine));
        return fileObject;
    }

    public StoredFileObject findByStoredFilename(String filename, String downloadUrl) {
        logger.warn((Object)String.format("Caution: The download url[%s] will be skipped", downloadUrl));
        return this.findByStoredFilename(filename);
    }

    public StoredFileObject delete(String filename) {
        String uploadEndpoint;
        if (StringUtils.isEmpty((Object)filename)) {
            return null;
        }
        if (filename.indexOf("?") > 0) {
            filename = filename.substring(0, filename.indexOf("?"));
        }
        if (!(uploadEndpoint = this.webDavProperties.getEndpoint()).endsWith("/")) {
            uploadEndpoint = uploadEndpoint.concat("/");
        }
        String remoteFilename = uploadEndpoint.concat(filename);
        try {
            if (!this.sardine.exists(remoteFilename)) {
                return null;
            }
        }
        catch (IOException e) {
            logger.error((Object)String.format("Fail to delete file %s", filename));
            return null;
        }
        DefaultStoredFileObject fileObject = new DefaultStoredFileObject();
        try {
            List davResources = this.sardine.list(remoteFilename);
            if (davResources != null && davResources.size() == 1) {
                DavResource davResource = (DavResource)davResources.get(0);
                this.buildStoreFileObject(davResource, fileObject);
            }
        }
        catch (IOException e) {
            logger.error((Object)String.format("Fail to resolve metadata of %s", remoteFilename), (Throwable)e);
        }
        fileObject.setStoredFilename(filename);
        fileObject.setProviderName(PROVIDER_NAME);
        fileObject.setImplementation(null);
        try {
            this.sardine.delete(remoteFilename);
            logger.info((Object)String.format("The file [%s] is deleted", filename));
        }
        catch (Throwable e) {
            logger.error((Object)String.format("Fail to delete the file [%s]", filename), e);
        }
        return fileObject;
    }

    private void buildStoreFileObject(DavResource davResource, DefaultStoredFileObject fileObject) {
        Map userMetadata = davResource.getCustomProps();
        if (userMetadata == null) {
            return;
        }
        try {
            fileObject.setOriginalFilename((String)userMetadata.get("fss-originalFilename"));
            fileObject.setPrettyFilename((String)userMetadata.get("fss-prettyFilename"));
            fileObject.setContentType((String)userMetadata.get("fss-contentType"));
            fileObject.setUploadedBy((String)userMetadata.get("fss-uploadedBy"));
            String uploadedAt = (String)userMetadata.get("fss-uploadedAt");
            fileObject.setUploadedAt(uploadedAt != null ? new Date(Long.parseLong(uploadedAt)) : null);
            String size = (String)userMetadata.get("fss-size");
            fileObject.setSize(size != null ? Long.parseLong(size) : -1L);
        }
        catch (Throwable e) {
            logger.error((Object)e, e);
        }
        try {
            HashMap attributes = new HashMap();
            userMetadata.keySet().stream().filter(key -> key.startsWith("fss-attrs-")).forEach(key -> {
                String attributeName = key.substring("fss-attrs-".length());
                attributes.put(attributeName, userMetadata.get(key));
            });
            fileObject.setAttributes(attributes);
        }
        catch (Throwable e) {
            logger.error((Object)e, e);
        }
    }

    private String createDirectory(String uploadEndpoint) throws IOException {
        Date now = new Date();
        if (!uploadEndpoint.endsWith("/")) {
            uploadEndpoint = uploadEndpoint.concat("/");
        }
        uploadEndpoint = uploadEndpoint.concat(new SimpleDateFormat("yyyy").format(now));
        if (!this.sardine.exists(uploadEndpoint)) {
            this.sardine.createDirectory(uploadEndpoint);
        }
        uploadEndpoint = uploadEndpoint.concat("/").concat(new SimpleDateFormat("MM").format(now));
        if (!this.sardine.exists(uploadEndpoint)) {
            this.sardine.createDirectory(uploadEndpoint);
        }
        uploadEndpoint = uploadEndpoint.concat("/").concat(new SimpleDateFormat("dd").format(now));
        if (!this.sardine.exists(uploadEndpoint)) {
            this.sardine.createDirectory(uploadEndpoint);
        }
        return new SimpleDateFormat("yyyy/MM/dd").format(now);
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.webDavProperties);
        if (this.webDavProperties.isSslEnabled()) {
            final SSLSocketFactory socketFactory = new SSLSocketFactory((TrustStrategy)new TrustSelfSignedStrategy());
            this.sardine = new SardineImpl(){

                protected SSLSocketFactory createDefaultSecureSocketFactory() {
                    return socketFactory;
                }
            };
        } else {
            this.sardine = SardineFactory.begin((String)this.webDavProperties.getUsername(), (String)this.webDavProperties.getPassword());
        }
    }
}

