package in.clouthink.daas.sbpm.core.model;

import java.util.List;

/**
 * @author dz
 */
public interface ActivityDefinition {

	/**
	 * The unique id
	 *
	 * @return
	 */
	String getId();

	/**
	 * The display name
	 *
	 * @return
	 */
	String getName();

	/**
	 * @return
	 */
	ActivityType getType();

	/**
	 * The participant expression
	 *
	 * @return
	 */
	String getParticipant();

	/**
	 * If the actions is null or empty, it means the process is at the end status.
	 *
	 * @return
	 */
	List<? extends ActivityRouter> getRouters();

	/**
	 * The process definition which the activity definition belongs to.
	 *
	 * @return
	 */
	ProcessDefinition getProcessDefinition();
}
