package in.clouthink.daas.sbpm.core.model;


/**
 * @author dz
 */
public enum ActivityType {

	/**
	 * 启动,不能指定参与者,启动流程的人会自动成为开始活动节点的参与者
	 */
	Start,
	/**
	 * 自由式,可以多个人收到任务,处理任务后可以自由提交流转,不需要关注其他人的处理状态
	 */
	//Free,
	/**
	 * 多人汇总式,可以多个人收到任务,必须所有人的人都处理汇总后才能流转到下一个环节（暂不支持）
	 */
	//Concurrent,
	/**
	 * 自动处理,处理后自动到下一环节
	 */
	//Auto
	/**
	 * 多人抢占式,可以多个人收到任务,但是只有一个人能处理
	 */
	Preemptive,
	/**
	 * 结束,只能有一个参与者
	 */
	End

}

