package in.clouthink.daas.sbpm.core.model;

/**
 * The default NamedUserReference impl.
 *
 * @author dz
 */
public class DefaultNamedUserReference extends DefaultUserReference implements NamedUserReference {

	public static final DefaultNamedUserReference from(UserReference userReference) {
		DefaultNamedUserReference result = null;
		if (userReference instanceof DefaultNamedUserReference) {
			result = (DefaultNamedUserReference) userReference;
		}
		if (result == null) {
			result = new DefaultNamedUserReference();
			result.setRefId(userReference.getRefId());
			result.setType(userReference.getType());
			if (result instanceof NamedUserReference) {
				result.setName(((NamedUserReference) userReference).getName());
			}
		}
		return result;
	}

	private String name;

	@Override
	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

}
