package in.clouthink.daas.sbpm.core.model;

/**
 * The default ProcessDefinitionReference impl.
 *
 * @author dz
 */
public class DefaultProcessDefinitionReference implements ProcessDefinitionReference {

	public static final DefaultProcessDefinitionReference from(ProcessDefinition processDefinition) {
		DefaultProcessDefinitionReference processDefinitionReference = new DefaultProcessDefinitionReference();
		processDefinitionReference.setRefId(processDefinition.getId());
		processDefinitionReference.setName(processDefinition.getName());
		processDefinitionReference.setDefinition(processDefinition.getDefinition());
		return processDefinitionReference;
	}

	private String refId;

	private String name;

	private String definition;

	@Override
	public String getRefId() {
		return refId;
	}

	public void setRefId(String refId) {
		this.refId = refId;
	}

	@Override
	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	@Override
	public String getDefinition() {
		return definition;
	}

	public void setDefinition(String definition) {
		this.definition = definition;
	}
}
