package in.clouthink.daas.sbpm.core.service;

import in.clouthink.daas.sbpm.core.model.*;
import org.springframework.data.domain.Page;

import java.util.List;

/**
 * @author dz
 */
public interface WorkflowService {

	/**
	 * @param id
	 * @return
	 */
	ProcessDefinition findProcessDefinitionById(String id);

	/**
	 * @param id
	 * @return
	 */
	ActivityDefinition findActivityDefinitionById(String id);

	/**
	 * 返回流程第一节点支持的操作（只会返回一个动作,如果流程定义了多个动作,则只返回第一个动作）
	 *
	 * @param processDefinitionId
	 * @return
	 */
	ActionReference getStartAction(String processDefinitionId);

	/**
	 * 流程,用户行为自动定位在start活动,并标记该活动为完成状态
	 *
	 * @param processDefinitionId
	 * @param actionRequest
	 * @param user
	 * @return
	 */
	ProcessInstance startProcess(String processDefinitionId, ActionRequest actionRequest, UserReference user);

	/**
	 * 根据id查询流程实例
	 *
	 * @param processInstanceId
	 * @return
	 */
	ProcessInstance findProcessInstanceById(String processInstanceId);

	/**
	 * @param id
	 * @return
	 */
	ActivityInstance findActivityInstanceById(String id);

	/**
	 * 获取活动的处理历史
	 *
	 * @param processInstanceId
	 * @return
	 */
	List<ProcessHistory> listProcessHistories(String processInstanceId);


	/**
	 * 获取当前活动的支持的操作（审批,驳回等）
	 *
	 * @param activityInstanceId
	 * @return
	 */
	List<ActionReference> getNextActions(String activityInstanceId);

	/**
	 * 签收任务(任务只有先签收才能处理,即使只有一个人有任务)
	 *
	 * @param activityInstanceId
	 * @param user
	 * @return
	 */
	ActivityInstance claimActivity(String activityInstanceId, UserReference user);

	/**
	 * 处理活动
	 *
	 * @param activityInstanceId
	 * @param actionRequest
	 * @return
	 */
	ActivityInstance processActivity(String activityInstanceId, ActionRequest actionRequest, UserReference user);

	/**
	 * 根据状态查询任务（待办,已办,其他（被其他用户抢占））
	 *
	 * @param queryRequest
	 * @return
	 */
	Page<ActivityInstance> listActivities(ActivityQueryRequest queryRequest);

}
