package in.clouthink.daas.sbpm.mongodb.model;

import in.clouthink.daas.sbpm.core.model.ActivityType;
import in.clouthink.daas.sbpm.core.model.DefaultActivityRouter;
import org.springframework.data.mongodb.core.mapping.DBRef;
import org.springframework.data.mongodb.core.mapping.Document;

import java.util.ArrayList;
import java.util.List;

/**
 * @author dz
 */
@Document(collection = "ActivityDefinitions")
public class ActivityDefinition extends StringIdentifier implements in.clouthink.daas.sbpm.core.model.ActivityDefinition {

	private String name;

	private ActivityType type;

	private String participant;

	private List<DefaultActivityRouter> routers = new ArrayList();

	@DBRef(lazy = true)
	private ProcessDefinition processDefinition;

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	@Override
	public ActivityType getType() {
		return type;
	}

	public void setType(ActivityType type) {
		this.type = type;
	}

	@Override
	public String getParticipant() {
		return participant;
	}

	public void setParticipant(String participant) {
		this.participant = participant;
	}

	@Override
	public List<DefaultActivityRouter> getRouters() {
		return routers;
	}

	public void setRouters(List<DefaultActivityRouter> routers) {
		this.routers = routers;
	}

	@Override
	public ProcessDefinition getProcessDefinition() {
		return processDefinition;
	}

	public void setProcessDefinition(ProcessDefinition processDefinition) {
		this.processDefinition = processDefinition;
	}
}
