package in.clouthink.daas.sbpm.mongodb.model;

import in.clouthink.daas.sbpm.core.model.ActivityStatus;
import in.clouthink.daas.sbpm.core.model.DefaultActionReference;
import in.clouthink.daas.sbpm.core.model.DefaultBusinessReference;
import in.clouthink.daas.sbpm.core.model.DefaultUserReference;
import org.springframework.data.mongodb.core.index.Indexed;
import org.springframework.data.mongodb.core.mapping.DBRef;
import org.springframework.data.mongodb.core.mapping.Document;

import java.util.Date;

/**
 * 流转过程中,每个人在每一个环节有且仅有一个活动（如果回退或者重复提交,以前的状态被重置为pending状态）
 *
 * @author dz
 */
@Document(collection = "ActivityInstances")
public class ActivityInstance extends StringIdentifier implements in.clouthink.daas.sbpm.core.model.ActivityInstance {

	private String name;

	@Indexed
	@DBRef(lazy = true)
	ProcessInstance processInstance;

	@Indexed
	@DBRef(lazy = true)
	ActivityDefinition activityDefinition;

	DefaultBusinessReference businessReference;

	ActivityStatus status;

	DefaultActionReference fromAction;

	DefaultUserReference fromBy;

	@Indexed
	DefaultUserReference receiver;

	Date receiveAt;

	DefaultActionReference processAction;

	DefaultUserReference processBy;

	Date processAt;

	@Override
	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	@Override
	public ProcessInstance getProcessInstance() {
		return processInstance;
	}

	public void setProcessInstance(ProcessInstance processInstance) {
		this.processInstance = processInstance;
	}

	@Override
	public ActivityDefinition getActivityDefinition() {
		return activityDefinition;
	}

	public void setActivityDefinition(ActivityDefinition activityDefinition) {
		this.activityDefinition = activityDefinition;
	}

	@Override
	public DefaultBusinessReference getBusinessReference() {
		return businessReference;
	}

	public void setBusinessReference(DefaultBusinessReference businessReference) {
		this.businessReference = businessReference;
	}

	@Override
	public ActivityStatus getStatus() {
		return status;
	}

	public void setStatus(ActivityStatus status) {
		this.status = status;
	}

	@Override
	public DefaultActionReference getFromAction() {
		return fromAction;
	}

	public void setFromAction(DefaultActionReference fromAction) {
		this.fromAction = fromAction;
	}

	@Override
	public DefaultUserReference getFromBy() {
		return fromBy;
	}

	public void setFromBy(DefaultUserReference fromBy) {
		this.fromBy = fromBy;
	}

	@Override
	public DefaultUserReference getReceiver() {
		return receiver;
	}

	public void setReceiver(DefaultUserReference receiver) {
		this.receiver = receiver;
	}

	@Override
	public Date getReceiveAt() {
		return receiveAt;
	}

	public void setReceiveAt(Date receiveAt) {
		this.receiveAt = receiveAt;
	}

	@Override
	public DefaultActionReference getProcessAction() {
		return processAction;
	}

	public void setProcessAction(DefaultActionReference processAction) {
		this.processAction = processAction;
	}

	@Override
	public DefaultUserReference getProcessBy() {
		return processBy;
	}

	public void setProcessBy(DefaultUserReference processBy) {
		this.processBy = processBy;
	}

	@Override
	public Date getProcessAt() {
		return processAt;
	}

	public void setProcessAt(Date processAt) {
		this.processAt = processAt;
	}
}
