package in.clouthink.daas.sbpm.mongodb.model;

import in.clouthink.daas.sbpm.core.model.ActivityInstance;
import in.clouthink.daas.sbpm.core.model.DefaultActionReference;
import in.clouthink.daas.sbpm.core.model.DefaultUserReference;
import org.springframework.data.mongodb.core.index.Indexed;
import org.springframework.data.mongodb.core.mapping.DBRef;
import org.springframework.data.mongodb.core.mapping.Document;

import java.util.Date;

/**
 * @author dz
 */
@Document(collection = "ProcessHistories")
public class ProcessHistory extends StringIdentifier implements in.clouthink.daas.sbpm.core.model.ProcessHistory {

	private String name;

	@Indexed
	@DBRef(lazy = true)
	private ProcessInstance processInstance;

	@DBRef(lazy = true)
	private ActivityInstance activityInstance;

	private DefaultActionReference action;

	private DefaultUserReference processBy;

	private Date processAt;

	private String memo;

	@Override
	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	@Override
	public ProcessInstance getProcessInstance() {
		return processInstance;
	}

	public void setProcessInstance(ProcessInstance processInstance) {
		this.processInstance = processInstance;
	}

	@Override
	public ActivityInstance getActivityInstance() {
		return activityInstance;
	}

	public void setActivityInstance(ActivityInstance activityInstance) {
		this.activityInstance = activityInstance;
	}

	@Override
	public DefaultActionReference getAction() {
		return action;
	}

	public void setAction(DefaultActionReference action) {
		this.action = action;
	}

	@Override
	public DefaultUserReference getProcessBy() {
		return processBy;
	}

	public void setProcessBy(DefaultUserReference processBy) {
		this.processBy = processBy;
	}

	@Override
	public Date getProcessAt() {
		return processAt;
	}

	public void setProcessAt(Date processAt) {
		this.processAt = processAt;
	}

	@Override
	public String getMemo() {
		return memo;
	}

	public void setMemo(String memo) {
		this.memo = memo;
	}

}
