package in.clouthink.daas.sbpm.mongodb.model;

import in.clouthink.daas.sbpm.core.model.DefaultBusinessReference;
import in.clouthink.daas.sbpm.core.model.DefaultProcessDefinitionReference;
import in.clouthink.daas.sbpm.core.model.DefaultUserReference;
import in.clouthink.daas.sbpm.core.model.ProcessStatus;
import org.springframework.data.mongodb.core.mapping.Document;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/**
 * @author dz
 */
@Document(collection = "ProcessInstances")
public class ProcessInstance extends StringIdentifier implements in.clouthink.daas.sbpm.core.model.ProcessInstance {

	private DefaultProcessDefinitionReference processDefinition;

	private DefaultBusinessReference businessReference;

	private ProcessStatus status;

	private DefaultUserReference createdBy;

	private Date createdAt;

	private DefaultUserReference endBy;

	private Date endAt;

	private Map<String,Object> attributes = new HashMap<>();

	@Override
	public DefaultProcessDefinitionReference getProcessDefinition() {
		return processDefinition;
	}

	public void setProcessDefinition(DefaultProcessDefinitionReference processDefinition) {
		this.processDefinition = processDefinition;
	}

	@Override
	public DefaultBusinessReference getBusinessReference() {
		return businessReference;
	}

	public void setBusinessReference(DefaultBusinessReference businessReference) {
		this.businessReference = businessReference;
	}

	@Override
	public ProcessStatus getStatus() {
		return status;
	}

	public void setStatus(ProcessStatus status) {
		this.status = status;
	}

	@Override
	public DefaultUserReference getCreatedBy() {
		return createdBy;
	}

	public void setCreatedBy(DefaultUserReference createdBy) {
		this.createdBy = createdBy;
	}

	@Override
	public Date getCreatedAt() {
		return createdAt;
	}

	public void setCreatedAt(Date createdAt) {
		this.createdAt = createdAt;
	}

	@Override
	public DefaultUserReference getEndBy() {
		return endBy;
	}

	public void setEndBy(DefaultUserReference endBy) {
		this.endBy = endBy;
	}

	@Override
	public Date getEndAt() {
		return endAt;
	}

	public void setEndAt(Date endAt) {
		this.endAt = endAt;
	}

	@Override
	public Map<String,Object> getAttributes() {
		return attributes;
	}

	public void setAttributes(Map<String,Object> attributes) {
		this.attributes = attributes;
	}
}
