package in.clouthink.daas.sbpm.mongodb.repository;


import in.clouthink.daas.sbpm.mongodb.model.ActivityInstance;
import in.clouthink.daas.sbpm.mongodb.repository.custom.ActivityInstanceRepositoryCustom;
import org.bson.types.ObjectId;
import org.springframework.data.mongodb.repository.Query;

import java.util.List;

/**
 * @author dz
 */
public interface ActivityInstanceRepository extends AbstractRepository<ActivityInstance>,
													ActivityInstanceRepositoryCustom {

	/**
	 * @param activityDefinitionId must be ObjectId type (the id of activity defintion is generated by mongodb)
	 * @param bizRefId
	 * @return
	 */
	@Query("{ 'activityDefinition.$id' : ?0, 'businessReference.refId' : ?1 }")
	List<ActivityInstance> findListByActivityDefinitionAndBusinessReferenceOrderByReceiveAtDesc(String activityDefinitionId,
																								String bizRefId);

	/**
	 * @param processInstanceId    must be ObjectId type (the id of process instance is generated by mongodb)
	 * @param activityDefinitionId must be String type (the id of activity definition is assigned by hard code)
	 * @param receiverId
	 * @return
	 */
	@Query("{ 'processInstance.$id' : ?0, 'activityDefinition.$id' : ?1 , 'receiver.refId': ?2}")
	ActivityInstance findFirstByProcessInstanceAndActivityDefinitionAndReceiver(ObjectId processInstanceId,
																				String activityDefinitionId,
																				String receiverId);

}