package in.clouthink.daas.sbpm.mongodb.repository.custom.impl;

import in.clouthink.daas.sbpm.core.model.ActivityQueryRequest;
import in.clouthink.daas.sbpm.mongodb.model.ActivityInstance;
import in.clouthink.daas.sbpm.mongodb.model.ProcessInstance;
import in.clouthink.daas.sbpm.mongodb.repository.custom.ActivityInstanceRepositoryCustom;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Repository;
import org.springframework.util.StringUtils;

import java.util.List;

@Repository
public class ActivityInstanceRepositoryImpl implements
                                            ActivityInstanceRepositoryCustom {
    @Autowired
    private MongoTemplate mongoTemplate;
    
    @Override
    public Page<ActivityInstance> queryPage(ActivityQueryRequest queryRequest) {
        int start = queryRequest.getStart();
        int limit = queryRequest.getLimit();
        Query query = buildQuery(queryRequest);
        
        PageRequest pageable = new PageRequest(start,
                                               limit,
                                               new Sort(Sort.Direction.DESC,
                                                        "receiveAt"));
        query.with(pageable);
        long count = mongoTemplate.count(query, ActivityInstance.class);
        List<ActivityInstance> list = mongoTemplate.find(query,
                                                         ActivityInstance.class);
                                                         
        return new PageImpl<>(list, pageable, count);
    }
    
    private Query buildQuery(ActivityQueryRequest request) {
        Query query = new Query();
        
        if (request.getActivityStatus() != null
            && request.getActivityStatus().length > 0) {
            query.addCriteria(Criteria.where("status")
                                      .in(request.getActivityStatus()));
        }
        
        if (!StringUtils.isEmpty(request.getBusinessType())) {
            query.addCriteria(Criteria.where("businessReference.type")
                                      .is(request.getBusinessType()));
        }
        
        if (!StringUtils.isEmpty(request.getProcessInstanceId())) {
            query.addCriteria(Criteria.where("processInstance")
                                      .is(mongoTemplate.findById(request.getProcessInstanceId(),
                                                                 ProcessInstance.class)));
        }
        
        if (!StringUtils.isEmpty(request.getReceiverId())) {
            query.addCriteria(Criteria.where("receiver.refId")
                                      .is(request.getReceiverId()));
        }
        
        return query;
    }
    
}
