package in.clouthink.daas.sbpm.mongodb.spiImpl;

import in.clouthink.daas.sbpm.core.exception.ParticipantParserException;
import in.clouthink.daas.sbpm.core.model.DefaultParticipant;
import in.clouthink.daas.sbpm.core.model.Participant;
import in.clouthink.daas.sbpm.core.spi.ParticipantParser;
import org.springframework.util.StringUtils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/**
 * @author dz
 */
public class ParticipantParserImpl implements ParticipantParser<Participant> {

	@Override
	public List<Participant> parse(String participantExpression) {
		if (StringUtils.isEmpty(participantExpression)) {
			return Collections.emptyList();
		}
		String[] splitParticipants = participantExpression.split(",");
		List<Participant> result = new ArrayList<>();
		for (String item : splitParticipants) {
			if (StringUtils.isEmpty(item)) {
				continue;
			}

			String[] splitItem = item.split(":");
			if (splitItem.length != 2) {
				throw new ParticipantParserException("不支持的参与者表达式");
			}

			if (!"SysUser".equalsIgnoreCase(splitItem[0])) {
				throw new ParticipantParserException("不支持的参与者表达式");
			}

			String parsedId = splitItem[1];
			//if sysUser is null, it's possible that the sys user is deleted
			//so ignore it (instead of  throw not found exception)
			if (!StringUtils.isEmpty(parsedId)) {
				DefaultParticipant principal = new DefaultParticipant();
				principal.setId(parsedId);
				principal.setType("mock");
				result.add(principal);
			}
		}

		return result;
	}

}
