package in.clouthink.daas.sbpm.mongodb.spiImpl;

import in.clouthink.daas.sbpm.core.model.*;
import in.clouthink.daas.sbpm.core.spi.WorkflowRepository;
import in.clouthink.daas.sbpm.mongodb.repository.*;
import org.bson.types.ObjectId;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/**
 * The workflow repository impl.
 *
 * @author dz
 */
public class WorkflowRepositoryImpl implements WorkflowRepository {

	@Autowired
	private ActivityDefinitionRepository activityDefinitionRepository;

	@Autowired
	private ActivityInstanceRepository activityInstanceRepository;

	@Autowired
	private ProcessDefinitionRepository processDefinitionRepository;

	@Autowired
	private ProcessHistoryRepository processHistoryRepository;

	@Autowired
	private ProcessInstanceRepository processInstanceRepository;

	@Override
	public ProcessDefinition findProcessDefinitionById(String processDefinitionId) {
		return processDefinitionRepository.findById(processDefinitionId);
	}

	@Override
	public List<ProcessDefinition> listProcessDefinitions() {
		List<ProcessDefinition> result = new ArrayList<>();
		result.addAll((List) processDefinitionRepository.findAll());
		return result;
	}

	@Override
	public ProcessDefinition saveProcessDefinition(ProcessDefinition request) {
		return processDefinitionRepository.save((in.clouthink.daas.sbpm.mongodb.model.ProcessDefinition) request);
	}

	@Override
	public ProcessDefinition deleteProcessDefinition(String processDefinitionId) {
		throw new UnsupportedOperationException("目前不支持删除操作");
		//return null;
	}

	@Override
	public ActivityDefinition findActivityDefinitionById(String activityDefinitionId) {
		return activityDefinitionRepository.findById(activityDefinitionId);
	}

	@Override
	public List<ActivityDefinition> listActivityDefinitions(String processDefinitionId) {
		ProcessDefinition processDefinition = processDefinitionRepository.findById(processDefinitionId);
		if (processDefinition == null) {
			return Collections.emptyList();
		}
		return listActivityDefinitions(processDefinition);
	}

	@Override
	public List<ActivityDefinition> listActivityDefinitions(ProcessDefinition processDefinition) {
		List<ActivityDefinition> result = new ArrayList<>();
		result.addAll((List) activityDefinitionRepository.findListByProcessDefinitionOrderByIdAsc((in.clouthink.daas.sbpm.mongodb.model.ProcessDefinition) processDefinition));
		return result;
	}

	@Override
	public ActivityDefinition saveActivityDefinition(ActivityDefinition request) {
		if (request instanceof in.clouthink.daas.sbpm.mongodb.model.ActivityDefinition) {
			return activityDefinitionRepository.save((in.clouthink.daas.sbpm.mongodb.model.ActivityDefinition) request);
		}
		in.clouthink.daas.sbpm.mongodb.model.ActivityDefinition entityToSave = new in.clouthink.daas.sbpm.mongodb.model.ActivityDefinition();
		BeanUtils.copyProperties(request, entityToSave);
		entityToSave.setProcessDefinition((in.clouthink.daas.sbpm.mongodb.model.ProcessDefinition) request.getProcessDefinition());
		return activityDefinitionRepository.save(entityToSave);
	}

	@Override
	public ActivityDefinition deleteActivityDefinition(String activityDefinitionId) {
		throw new UnsupportedOperationException("目前不支持删除操作");
		//		return null;
	}

	@Override
	public ProcessInstance findProcessInstanceById(String processInstanceId) {
		return processInstanceRepository.findById(processInstanceId);
	}

	@Override
	public ProcessInstance updateProcessInstance(String processInstanceId, ProcessStatus processStatus) {
		in.clouthink.daas.sbpm.mongodb.model.ProcessInstance result = processInstanceRepository.findById(
				processInstanceId);
		if (result != null && processStatus != null) {
			result.setStatus(processStatus);
			result = processInstanceRepository.save(result);
		}
		return result;
	}

	@Override
	public Page<ProcessInstance> listProcessInstances(String processDefinitionId, Pageable pageable) {
		Page<in.clouthink.daas.sbpm.mongodb.model.ProcessInstance> result = processInstanceRepository.findPageByProcessDefinitionId(
				processDefinitionId,
				pageable);
		List<ProcessInstance> content = new ArrayList<>();
		content.addAll((List) result.getContent());
		return new PageImpl<>(content, pageable, result.getTotalElements());
	}

	@Override
	public ProcessInstance saveProcessInstance(ProcessInstance request) {
		return processInstanceRepository.save((in.clouthink.daas.sbpm.mongodb.model.ProcessInstance) request);
	}

	@Override
	public ProcessInstance deleteProcessInstance(String processInstanceId) {
		throw new UnsupportedOperationException("目前不支持删除操作");
		//		return null;
	}

	@Override
	public List<ProcessHistory> listProcessHistories(String processInstanceId) {
		ProcessInstance processInstance = processInstanceRepository.findById(processInstanceId);
		if (processInstance == null) {
			return Collections.emptyList();
		}

		List<ProcessHistory> result = new ArrayList<>();
		result.addAll(processHistoryRepository.findListByProcessInstanceOrderByProcessAtAsc((in.clouthink.daas.sbpm.mongodb.model.ProcessInstance) processInstance));
		return result;
	}

	@Override
	public ProcessHistory findProcessHistoryById(String historyId) {
		return processHistoryRepository.findById(historyId);
	}

	@Override
	public ProcessHistory saveProcessHistory(ProcessHistory request) {
		return processHistoryRepository.save((in.clouthink.daas.sbpm.mongodb.model.ProcessHistory) request);
	}

	@Override
	public ActivityInstance saveActivityInstance(ActivityInstance request) {
		return activityInstanceRepository.save((in.clouthink.daas.sbpm.mongodb.model.ActivityInstance) request);
	}

	@Override
	public ActivityInstance updateActivityInstance(String activityInstanceId, ActivityStatus status) {
		in.clouthink.daas.sbpm.mongodb.model.ActivityInstance result = activityInstanceRepository.findById(
				activityInstanceId);
		if (result != null && status != null) {
			result.setStatus(status);
			result = activityInstanceRepository.save(result);
		}
		return result;
	}

	@Override
	public ActivityInstance findActivityInstanceById(String activityInstanceId) {
		return activityInstanceRepository.findById(activityInstanceId);
	}

	@Override
	public Page<ActivityInstance> listActivityInstances(ActivityQueryRequest queryRequest) {
		Page<in.clouthink.daas.sbpm.mongodb.model.ActivityInstance> result = activityInstanceRepository.queryPage(
				queryRequest);
		List<ActivityInstance> content = new ArrayList<>();
		content.addAll((List) result.getContent());
		return new PageImpl<>(content,
							  new PageRequest(queryRequest.getStart(), queryRequest.getLimit()),
							  result.getTotalElements());
	}

	@Override
	public List<ActivityInstance> listActivityInstances(ActivityDefinition activityDefinition,
														BusinessReference businessReference) {
		List<ActivityInstance> result = new ArrayList<>();
		result.addAll(activityInstanceRepository.findListByActivityDefinitionAndBusinessReferenceOrderByReceiveAtDesc(
				activityDefinition.getId(),
				businessReference.getRefId()));
		return result;
	}

	@Override
	public ActivityInstance findActivityInstance(ProcessInstance processInstance,
												 ActivityDefinition activityDefinition,
												 UserReference receiverReference) {
		return activityInstanceRepository.findFirstByProcessInstanceAndActivityDefinitionAndReceiver(new ObjectId(
				processInstance.getId()), activityDefinition.getId(), receiverReference.getRefId());
	}

}
