/*
 * Decompiled with CFR 0.152.
 */
package in.clouthink.daas.security.token.support.web;

import in.clouthink.daas.security.token.support.web.AuthenticationFailureHandler;
import in.clouthink.daas.security.token.support.web.DefaultWebResponseExceptionTranslator;
import in.clouthink.daas.security.token.support.web.HttpResponseJsonRenderer;
import in.clouthink.daas.security.token.support.web.HttpResponseRenderer;
import in.clouthink.daas.security.token.support.web.WebResponseExceptionTranslator;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.http.HttpEntity;
import org.springframework.http.ResponseEntity;

public class DefaultAuthenticationFailureHandler
implements AuthenticationFailureHandler {
    private WebResponseExceptionTranslator translater = new DefaultWebResponseExceptionTranslator();
    private HttpResponseRenderer renderer = new HttpResponseJsonRenderer();

    public WebResponseExceptionTranslator getTranslater() {
        return this.translater;
    }

    public void setTranslater(WebResponseExceptionTranslator translater) {
        this.translater = translater;
    }

    public HttpResponseRenderer getRenderer() {
        return this.renderer;
    }

    public void setRenderer(HttpResponseRenderer renderer) {
        this.renderer = renderer;
    }

    @Override
    public void handle(HttpServletRequest request, HttpServletResponse response, Exception exception) throws IOException, ServletException {
        try {
            ResponseEntity<?> result = this.translater.translate(exception);
            this.renderer.handleResponse((HttpEntity<?>)result, request, response);
            response.flushBuffer();
        }
        catch (ServletException e) {
            throw e;
        }
        catch (IOException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }
}

