/*
 * Decompiled with CFR 0.152.
 */
package in.clouthink.daas.security.token.spi.impl;

import in.clouthink.daas.security.token.core.Token;
import in.clouthink.daas.security.token.spi.TokenProvider;

public class CompositeTokenProvider
implements TokenProvider<Token> {
    private TokenProvider frontProvider;
    private TokenProvider backProvider;

    public CompositeTokenProvider(TokenProvider frontProvider, TokenProvider backProvider) {
        this.frontProvider = frontProvider;
        this.backProvider = backProvider;
    }

    @Override
    public void saveToken(Token token) {
        if (token == null) {
            return;
        }
        this.frontProvider.saveToken(token);
        this.backProvider.saveToken(token);
    }

    @Override
    public Token findByToken(String token) {
        Object result = this.frontProvider.findByToken(token);
        if (result != null) {
            return result;
        }
        result = this.backProvider.findByToken(token);
        if (result != null) {
            this.frontProvider.saveToken(result);
            return result;
        }
        return result;
    }

    @Override
    public void revokeToken(Token token) {
        if (token == null) {
            return;
        }
        this.frontProvider.revokeToken(token);
        this.backProvider.revokeToken(token);
    }
}

