/*
 * Decompiled with CFR 0.152.
 */
package in.clouthink.daas.security.token.spi.impl.redis;

import in.clouthink.daas.security.token.core.Token;
import in.clouthink.daas.security.token.spi.TokenProvider;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;

public class TokenProviderRedisImpl
implements TokenProvider<Token> {
    public static final Log logger = LogFactory.getLog(TokenProviderRedisImpl.class);
    @Autowired
    private RedisTemplate<String, Token> redisTemplate;

    @Override
    public void saveToken(Token token) {
        logger.debug((Object)String.format("Put T:%s expiredAt:%s", token.getToken(), token.getExpiredDate()));
        this.redisTemplate.opsForHash().put((Object)("T:" + token.getToken()), (Object)token.getToken(), (Object)token);
        this.redisTemplate.expireAt((Object)("T:" + token.getToken()), token.getExpiredDate());
    }

    @Override
    public Token findByToken(String token) {
        logger.debug((Object)String.format("Get T:%s", token));
        return (Token)this.redisTemplate.opsForHash().get((Object)("T:" + token), (Object)token);
    }

    @Override
    public void revokeToken(Token token) {
        logger.debug((Object)String.format("Del T:%s", token));
        if (token == null) {
            return;
        }
        this.redisTemplate.opsForHash().delete((Object)("T:" + token.getToken()), new Object[]{token.getToken()});
    }
}

