/*
 * Decompiled with CFR 0.152.
 */
package in.clouthink.daas.security.token.core;

import in.clouthink.daas.security.token.core.Authentication;
import in.clouthink.daas.security.token.core.AuthenticationManager;
import in.clouthink.daas.security.token.core.AuthenticationRequest;
import in.clouthink.daas.security.token.spi.AuthenticationProvider;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class DefaultAuthenticationManager
implements AuthenticationManager,
InitializingBean {
    private List<AuthenticationProvider> providers = new ArrayList<AuthenticationProvider>();

    public List<AuthenticationProvider> getProviders() {
        return this.providers;
    }

    public void setProviders(List<AuthenticationProvider> providers) {
        this.providers = providers;
    }

    public void addProvider(AuthenticationProvider provider) {
        this.providers.add(provider);
    }

    public void addProviders(AuthenticationProvider ... providers) {
        for (AuthenticationProvider provider : providers) {
            this.providers.add(provider);
        }
    }

    @Override
    public Authentication login(AuthenticationRequest request) {
        if (request == null) {
            return null;
        }
        for (AuthenticationProvider provider : this.providers) {
            if (!provider.supports(request)) continue;
            return provider.authenticate(request);
        }
        return null;
    }

    @Override
    public void logout(Authentication authentication) {
        if (authentication == null) {
            return;
        }
        for (AuthenticationProvider provider : this.providers) {
            provider.revoke(authentication);
        }
    }

    public void afterPropertiesSet() {
        Assert.notNull(this.providers, (String)"providers must be specified");
    }
}

