/*
 * Decompiled with CFR 0.152.
 */
package in.clouthink.daas.security.token.core;

import in.clouthink.daas.security.token.core.Token;
import in.clouthink.daas.security.token.core.TokenLifeSupport;
import in.clouthink.daas.security.token.core.TokenManager;
import in.clouthink.daas.security.token.core.User;
import in.clouthink.daas.security.token.spi.TokenProvider;
import in.clouthink.daas.security.token.spi.impl.model.TokenEntity;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;

public class DefaultTokenManager
implements TokenManager,
TokenLifeSupport,
InitializingBean {
    private TokenProvider tokenProvider;
    private long tokenTimeout = 3600000L;

    public long getTokenTimeout() {
        return this.tokenTimeout;
    }

    @Override
    public void setTokenTimeout(long tokenTimeout) {
        this.tokenTimeout = tokenTimeout;
    }

    @Autowired
    public TokenProvider getTokenProvider() {
        return this.tokenProvider;
    }

    public void setTokenProvider(TokenProvider tokenProvider) {
        this.tokenProvider = tokenProvider;
    }

    @Override
    public void refreshToken(String token) {
        TokenEntity result = (TokenEntity)this.tokenProvider.findByToken(token);
        if (result != null) {
            result.updateExpiredDate(this.tokenTimeout);
            this.tokenProvider.saveToken(result);
        }
    }

    @Override
    public Token createToken(User owner) {
        TokenEntity token = TokenEntity.create(owner, this.tokenTimeout);
        this.tokenProvider.saveToken(token);
        return token;
    }

    @Override
    public Token findToken(String token) {
        Object result = this.tokenProvider.findByToken(token);
        if (result.getExpiredDate().getTime() < System.currentTimeMillis()) {
            this.tokenProvider.revokeToken(result);
            return null;
        }
        return result;
    }

    @Override
    public void revokeToken(String token) {
        this.tokenProvider.revokeToken(this.findToken(token));
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.tokenProvider);
    }
}

