/*
 * Decompiled with CFR 0.152.
 */
package in.clouthink.daas.security.token.core;

import in.clouthink.daas.security.token.SecurityContext;
import in.clouthink.daas.security.token.core.DefaultSecurityContext;
import org.springframework.util.Assert;

public class SecurityContextManager {
    private static final ThreadLocal<SecurityContext> contextHolder = new ThreadLocal();

    public static void clearContext() {
        contextHolder.remove();
    }

    public static SecurityContext getContext() {
        SecurityContext ctx = contextHolder.get();
        if (ctx == null) {
            ctx = SecurityContextManager.createEmptyContext();
            contextHolder.set(ctx);
        }
        return ctx;
    }

    public static void setContext(SecurityContext context) {
        Assert.notNull((Object)context, (String)"Only non-null SecurityContext instances are permitted");
        contextHolder.set(context);
    }

    public static SecurityContext createEmptyContext() {
        return new DefaultSecurityContext();
    }
}

