/*
 * Decompiled with CFR 0.152.
 */
package in.clouthink.daas.security.token.spi.impl;

import in.clouthink.daas.security.token.core.Authentication;
import in.clouthink.daas.security.token.core.AuthenticationRequest;
import in.clouthink.daas.security.token.core.DefaultAuthentication;
import in.clouthink.daas.security.token.core.Token;
import in.clouthink.daas.security.token.core.TokenAuthenticationRequest;
import in.clouthink.daas.security.token.core.TokenManager;
import in.clouthink.daas.security.token.core.User;
import in.clouthink.daas.security.token.exception.InvalidTokenException;
import in.clouthink.daas.security.token.exception.TokenExpiredException;
import in.clouthink.daas.security.token.exception.UserDisabledException;
import in.clouthink.daas.security.token.exception.UserExpiredException;
import in.clouthink.daas.security.token.exception.UserLockedException;
import in.clouthink.daas.security.token.exception.UserNotFoundException;
import in.clouthink.daas.security.token.spi.AuthenticationProvider;
import in.clouthink.daas.security.token.spi.IdentityProvider;
import java.util.Date;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class TokenAuthenticationProvider
implements AuthenticationProvider<TokenAuthenticationRequest>,
InitializingBean {
    private IdentityProvider identityProvider;
    private TokenManager tokenManager;

    public void setIdentityProvider(IdentityProvider identityProvider) {
        this.identityProvider = identityProvider;
    }

    public TokenManager getTokenManager() {
        return this.tokenManager;
    }

    public void setTokenManager(TokenManager tokenManager) {
        this.tokenManager = tokenManager;
    }

    public IdentityProvider getIdentityProvider() {
        return this.identityProvider;
    }

    @Override
    public boolean supports(AuthenticationRequest request) {
        return request instanceof TokenAuthenticationRequest;
    }

    @Override
    public Authentication authenticate(TokenAuthenticationRequest tokenAuthenticationRequest) {
        String principal = tokenAuthenticationRequest.getPrincipal();
        Token token = this.tokenManager.findToken(principal);
        if (token == null) {
            throw new InvalidTokenException();
        }
        Date expiredDate = token.getExpiredDate();
        if (expiredDate.getTime() < System.currentTimeMillis()) {
            throw new TokenExpiredException();
        }
        User user = token.getOwner();
        if (user == null) {
            throw new UserNotFoundException();
        }
        if (user.isExpired()) {
            throw new UserExpiredException();
        }
        if (user.isLocked()) {
            throw new UserLockedException();
        }
        if (!user.isEnabled()) {
            throw new UserDisabledException();
        }
        this.tokenManager.refreshToken(token);
        return new DefaultAuthentication(token);
    }

    @Override
    public void revoke(Authentication authentication) {
        Token token = authentication.currentToken();
        this.tokenManager.revokeToken(token.getToken());
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.identityProvider);
        Assert.notNull((Object)this.tokenManager);
    }
}

