/*
 * Decompiled with CFR 0.152.
 */
package in.clouthink.daas.security.token.spi.impl.memory;

import in.clouthink.daas.security.token.core.Token;
import in.clouthink.daas.security.token.spi.TokenProvider;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.scheduling.annotation.Scheduled;

public class TokenProviderMemoryImpl
implements TokenProvider<Token> {
    public static final Log logger = LogFactory.getLog(TokenProviderMemoryImpl.class);
    private Map<String, Token> tokenTokenMap = new ConcurrentHashMap<String, Token>();

    @Override
    public void saveToken(Token token) {
        logger.debug((Object)String.format("Put token:%s expiredAt:%s", token.getToken(), token.getExpiredDate()));
        this.tokenTokenMap.put(token.getToken(), token);
    }

    @Override
    public Token findByToken(String token) {
        logger.debug((Object)String.format("Get token:%s", token));
        return this.tokenTokenMap.get(token);
    }

    @Override
    public void revokeToken(Token token) {
        logger.debug((Object)String.format("Del token:%s", token));
        if (token == null) {
            return;
        }
        this.tokenTokenMap.remove(token.getToken());
    }

    @Scheduled(cron="0 0/10 * * * ?")
    public void cleanExpiredToken() {
        logger.debug((Object)"Start to clean the expired token automatically.");
        HashSet<Token> tokens = new HashSet<Token>();
        for (Token token : this.tokenTokenMap.values()) {
            if (token.getExpiredDate().getTime() >= System.currentTimeMillis()) continue;
            tokens.add(token);
        }
        for (Token token : tokens) {
            this.tokenTokenMap.remove(token.getToken());
        }
    }
}

