/*
 * Decompiled with CFR 0.152.
 */
package in.clouthink.daas.security.token.support.web;

import in.clouthink.daas.security.token.exception.AccessDeniedException;
import in.clouthink.daas.security.token.exception.AuthenticationFailureException;
import in.clouthink.daas.security.token.exception.AuthenticationRequiredException;
import in.clouthink.daas.security.token.exception.AuthorizationFailureException;
import in.clouthink.daas.security.token.exception.BadCredetialException;
import in.clouthink.daas.security.token.exception.InvalidTokenException;
import in.clouthink.daas.security.token.exception.TokenExpiredException;
import in.clouthink.daas.security.token.exception.UserDisabledException;
import in.clouthink.daas.security.token.exception.UserExpiredException;
import in.clouthink.daas.security.token.exception.UserLockedException;
import in.clouthink.daas.security.token.exception.UserNotFoundException;
import in.clouthink.daas.security.token.support.i18n.DefaultMessageProvider;
import in.clouthink.daas.security.token.support.i18n.MessageProvider;
import in.clouthink.daas.security.token.support.web.WebResponseExceptionTranslator;
import in.clouthink.daas.security.token.support.web.WebResultWrapper;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;

public class DefaultWebResponseExceptionTranslator
implements WebResponseExceptionTranslator {
    private MessageProvider messageProvider = new DefaultMessageProvider();

    public DefaultWebResponseExceptionTranslator() {
    }

    public DefaultWebResponseExceptionTranslator(MessageProvider messageProvider) {
        this.messageProvider = messageProvider;
    }

    public void setMessageProvider(MessageProvider messageProvider) {
        this.messageProvider = messageProvider;
    }

    @Override
    public ResponseEntity<?> translate(Exception e) throws Exception {
        HttpHeaders headers = new HttpHeaders();
        headers.set("Cache-Control", "no-store");
        headers.set("Pragma", "no-cache");
        if (e instanceof UserNotFoundException) {
            return new ResponseEntity(WebResultWrapper.failedMap(this.messageProvider.getMessage("error.invalidUserOrPassword")), (MultiValueMap)headers, HttpStatus.OK);
        }
        if (e instanceof UserLockedException) {
            return new ResponseEntity(WebResultWrapper.failedMap(this.messageProvider.getMessage("error.userIsLocked")), (MultiValueMap)headers, HttpStatus.OK);
        }
        if (e instanceof UserExpiredException) {
            return new ResponseEntity(WebResultWrapper.failedMap(this.messageProvider.getMessage("error.userIsExpired")), (MultiValueMap)headers, HttpStatus.OK);
        }
        if (e instanceof UserDisabledException) {
            return new ResponseEntity(WebResultWrapper.failedMap(this.messageProvider.getMessage("error.userIsDisabled")), (MultiValueMap)headers, HttpStatus.OK);
        }
        if (e instanceof BadCredetialException) {
            return new ResponseEntity(WebResultWrapper.failedMap(this.messageProvider.getMessage("error.invalidUserOrPassword")), (MultiValueMap)headers, HttpStatus.OK);
        }
        if (e instanceof InvalidTokenException) {
            return new ResponseEntity(WebResultWrapper.failedMap(this.messageProvider.getMessage("error.invalidTokenOrExpired")), (MultiValueMap)headers, HttpStatus.OK);
        }
        if (e instanceof TokenExpiredException) {
            return new ResponseEntity(WebResultWrapper.failedMap(this.messageProvider.getMessage("error.invalidTokenOrExpired")), (MultiValueMap)headers, HttpStatus.OK);
        }
        if (e instanceof AuthenticationFailureException) {
            String message = e.getMessage();
            if (StringUtils.isEmpty((Object)message)) {
                message = this.messageProvider.getMessage("error.authenticationFailed");
            }
            return new ResponseEntity(WebResultWrapper.failedMap(message), (MultiValueMap)headers, HttpStatus.OK);
        }
        if (e instanceof AuthorizationFailureException) {
            String message = e.getMessage();
            if (StringUtils.isEmpty((Object)message)) {
                message = this.messageProvider.getMessage("error.authorizationFailed");
            }
            return new ResponseEntity(WebResultWrapper.failedMap(message), (MultiValueMap)headers, HttpStatus.UNAUTHORIZED);
        }
        if (e instanceof AuthenticationRequiredException) {
            String message = e.getMessage();
            if (StringUtils.isEmpty((Object)message)) {
                message = this.messageProvider.getMessage("error.authenticationRequired");
            }
            return new ResponseEntity(WebResultWrapper.failedMap(message), (MultiValueMap)headers, HttpStatus.UNAUTHORIZED);
        }
        if (e instanceof AccessDeniedException) {
            String message = e.getMessage();
            if (StringUtils.isEmpty((Object)message)) {
                message = this.messageProvider.getMessage("error.noPermission");
            }
            return new ResponseEntity(WebResultWrapper.failedMap(message), (MultiValueMap)headers, HttpStatus.FORBIDDEN);
        }
        return new ResponseEntity(WebResultWrapper.failedMap(e.getMessage()), (MultiValueMap)headers, HttpStatus.OK);
    }
}

