/*
 * Decompiled with CFR 0.152.
 */
package in.clouthink.daas.security.token.configure;

import in.clouthink.daas.security.token.core.acl.AntPathUrlAcl;
import in.clouthink.daas.security.token.core.acl.RegexUrlAcl;
import in.clouthink.daas.security.token.core.acl.UrlAcl;
import org.springframework.util.StringUtils;

public class UrlAclBuilder {
    UrlAclType type;
    String urlRealm;
    String[] httpMethods = new String[]{"*"};
    String[] grantRules = new String[0];
    private boolean caseSensitive;

    public static UrlAclBuilder regexBuilder() {
        return new UrlAclBuilder(UrlAclType.REGEX);
    }

    public static UrlAclBuilder antPathBuilder() {
        return new UrlAclBuilder(UrlAclType.ANTPATH);
    }

    UrlAclBuilder(UrlAclType type) {
        this.type = type;
    }

    public UrlAclBuilder url(String url) {
        this.urlRealm = url;
        return this;
    }

    public UrlAclBuilder caseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
        return this;
    }

    public UrlAclBuilder httpMethods(String ... httpMethods) {
        this.httpMethods = httpMethods;
        return this;
    }

    public UrlAclBuilder grantRules(String ... grantRules) {
        String[] parsedRules = new String[]{};
        for (String grantRule : grantRules) {
            parsedRules = grantRule.indexOf(",") > 0 ? StringUtils.concatenateStringArrays((String[])parsedRules, (String[])grantRule.split(",")) : StringUtils.concatenateStringArrays((String[])parsedRules, (String[])new String[]{grantRule});
        }
        this.grantRules = parsedRules;
        return this;
    }

    public UrlAcl build() {
        if (UrlAclType.ANTPATH == this.type) {
            return new AntPathUrlAcl(this.urlRealm, this.httpMethods, this.caseSensitive, this.grantRules);
        }
        if (UrlAclType.REGEX == this.type) {
            return new RegexUrlAcl(this.urlRealm, this.httpMethods, this.caseSensitive, this.grantRules);
        }
        return null;
    }

    static enum UrlAclType {
        REGEX,
        ANTPATH;

    }
}

