/*
 * Decompiled with CFR 0.152.
 */
package in.clouthink.daas.security.token.core;

import in.clouthink.daas.security.token.core.Token;
import in.clouthink.daas.security.token.core.TokenLifeSupport;
import in.clouthink.daas.security.token.core.TokenManager;
import in.clouthink.daas.security.token.core.User;
import in.clouthink.daas.security.token.spi.TokenProvider;
import in.clouthink.daas.security.token.spi.impl.model.TokenEntity;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;

public class DefaultTokenManager
implements TokenManager,
TokenLifeSupport,
InitializingBean {
    private TokenProvider tokenProvider;
    private long tokenTimeout = 3600000L;
    private long refreshTokenInteval = 180000L;

    public long getTokenTimeout() {
        return this.tokenTimeout;
    }

    @Override
    public void setTokenTimeout(long tokenTimeout) {
        this.tokenTimeout = tokenTimeout;
    }

    public long getRefreshTokenInteval() {
        return this.refreshTokenInteval;
    }

    @Override
    public void setRefreshTokenInteval(long refreshTokenInteval) {
        this.refreshTokenInteval = refreshTokenInteval;
    }

    @Autowired
    public TokenProvider getTokenProvider() {
        return this.tokenProvider;
    }

    public void setTokenProvider(TokenProvider tokenProvider) {
        this.tokenProvider = tokenProvider;
    }

    @Override
    public void refreshToken(Token token) {
        if (null == token.getLatestTime()) {
            token.updateExpiredDate(this.tokenTimeout);
            this.tokenProvider.saveToken(token);
            return;
        }
        long lastTime = token.getLatestTime().getTime();
        long currentTimeMillis = System.currentTimeMillis();
        if (currentTimeMillis - lastTime > this.refreshTokenInteval) {
            token.updateExpiredDate(this.tokenTimeout);
            this.tokenProvider.saveToken(token);
        }
    }

    @Override
    public Token createToken(User owner) {
        TokenEntity token = TokenEntity.create(owner, this.tokenTimeout);
        this.tokenProvider.saveToken(token);
        return token;
    }

    @Override
    public Token findToken(String token) {
        Object result = this.tokenProvider.findByToken(token);
        if (result == null) {
            return null;
        }
        if (result.getExpiredDate().getTime() < System.currentTimeMillis()) {
            this.tokenProvider.revokeToken(result);
            return null;
        }
        return result;
    }

    @Override
    public void revokeToken(String token) {
        this.tokenProvider.revokeToken(this.findToken(token));
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.tokenProvider);
    }
}

