/*
 * Decompiled with CFR 0.152.
 */
package in.clouthink.daas.security.token.spi.impl.model;

import in.clouthink.daas.security.token.core.Token;
import in.clouthink.daas.security.token.core.User;
import in.clouthink.daas.security.token.spi.KeyGeneratorFactory;
import java.util.Date;
import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.mapping.DBRef;
import org.springframework.data.mongodb.core.mapping.Document;

@Document(collection="Tokens")
public class TokenEntity
implements Token {
    @Id
    private String token;
    @DBRef
    private User owner;
    private Date expiredDate;
    private Date latestTime;

    public static TokenEntity create(User owner) {
        TokenEntity result = new TokenEntity();
        String value = KeyGeneratorFactory.getInstance().generateId();
        result.setToken(value);
        result.setOwner(owner);
        Date date = new Date(System.currentTimeMillis() + 86400000L);
        result.setExpiredDate(date);
        result.setLatestTime(new Date());
        return result;
    }

    public static TokenEntity create(User owner, long timeout) {
        TokenEntity result = new TokenEntity();
        String value = KeyGeneratorFactory.getInstance().generateId();
        result.setToken(value);
        result.setOwner(owner);
        Date date = new Date(System.currentTimeMillis() + timeout);
        result.setExpiredDate(date);
        result.setLatestTime(new Date());
        return result;
    }

    @Override
    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    @Override
    public User getOwner() {
        return this.owner;
    }

    public void setOwner(User owner) {
        this.owner = owner;
    }

    @Override
    public Date getExpiredDate() {
        return this.expiredDate;
    }

    public void setExpiredDate(Date expiredDate) {
        this.expiredDate = expiredDate;
    }

    @Override
    public Date getLatestTime() {
        return this.latestTime;
    }

    public void setLatestTime(Date latestTime) {
        this.latestTime = latestTime;
    }

    @Override
    public void updateExpiredDate(long timeout) {
        Date date = new Date(System.currentTimeMillis() + timeout);
        this.setExpiredDate(date);
        this.setLatestTime(new Date());
    }
}

