/*
 * Decompiled with CFR 0.152.
 */
package in.clouthink.daas.security.token.spi.impl;

import in.clouthink.daas.security.token.core.acl.AccessRequestVoter;
import in.clouthink.daas.security.token.core.acl.AccessResponse;
import in.clouthink.daas.security.token.core.acl.UrlAccessRequest;
import in.clouthink.daas.security.token.core.acl.UrlAcl;
import in.clouthink.daas.security.token.spi.AclProvider;
import in.clouthink.daas.security.token.spi.AuthorizationProvider;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class DefaultUrlAuthorizationProvider
implements AuthorizationProvider<UrlAccessRequest>,
InitializingBean {
    private static final Log logger = LogFactory.getLog(DefaultUrlAuthorizationProvider.class);
    private AclProvider<UrlAcl> provider;
    private List<AccessRequestVoter<UrlAccessRequest>> voters = new ArrayList<AccessRequestVoter<UrlAccessRequest>>();

    public AclProvider<UrlAcl> getProvider() {
        return this.provider;
    }

    public void setProvider(AclProvider<UrlAcl> provider) {
        this.provider = provider;
    }

    public List<AccessRequestVoter<UrlAccessRequest>> getVoters() {
        return this.voters;
    }

    public void setVoters(List<AccessRequestVoter<UrlAccessRequest>> voters) {
        this.voters = voters;
    }

    public void addVoter(AccessRequestVoter<UrlAccessRequest> voter) {
        this.voters.add(voter);
    }

    @Override
    public AccessResponse authorize(UrlAccessRequest accessRequest) {
        AccessResponse result = this.doAuthorize(accessRequest);
        logger.debug((Object)("Authorization result:" + (Object)((Object)result)));
        return result;
    }

    private AccessResponse doAuthorize(UrlAccessRequest accessRequest) {
        for (UrlAcl urlAcl : this.provider.listAll()) {
            if (!urlAcl.matches(accessRequest.getTarget(), accessRequest.getOperation())) continue;
            for (String grantRule : urlAcl.getGrantRules()) {
                for (AccessRequestVoter<UrlAccessRequest> voter : this.voters) {
                    AccessResponse accessResponse = voter.vote(accessRequest, grantRule);
                    if (AccessResponse.APPROVED != accessResponse) continue;
                    return accessResponse;
                }
            }
            return AccessResponse.REFUESD;
        }
        return AccessResponse.ABANDON;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull(this.provider);
        Assert.notEmpty(this.voters);
    }
}

