/*
 * Decompiled with CFR 0.152.
 */
package in.clouthink.daas.security.token.support.web;

import in.clouthink.daas.security.token.core.Authentication;
import in.clouthink.daas.security.token.core.AuthenticationManager;
import in.clouthink.daas.security.token.core.UsernamePasswordAuthenticationRequest;
import in.clouthink.daas.security.token.exception.AuthenticationException;
import in.clouthink.daas.security.token.exception.AuthenticationFailureException;
import in.clouthink.daas.security.token.repackage.org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import in.clouthink.daas.security.token.repackage.org.springframework.security.web.util.matcher.RequestMatcher;
import in.clouthink.daas.security.token.spi.AuditCallback;
import in.clouthink.daas.security.token.support.i18n.DefaultMessageProvider;
import in.clouthink.daas.security.token.support.i18n.MessageProvider;
import in.clouthink.daas.security.token.support.web.AuthenticationFailureHandler;
import in.clouthink.daas.security.token.support.web.AuthenticationSuccessHandler;
import in.clouthink.daas.security.token.support.web.DefaultAuthenticationFailureHandler;
import in.clouthink.daas.security.token.support.web.DefaultAuthenticationSuccessHandler;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.filter.GenericFilterBean;

public class LoginEndpoint
extends GenericFilterBean {
    private static final Log logger = LogFactory.getLog(LoginEndpoint.class);
    public static final String SECURITY_FORM_USERNAME_KEY = "username";
    public static final String SECURITY_FORM_PASSWORD_KEY = "password";
    private String usernameParameter = "username";
    private String passwordParameter = "password";
    private boolean postOnly = true;
    private AuthenticationSuccessHandler authenticationSuccessHandler = new DefaultAuthenticationSuccessHandler();
    private AuthenticationFailureHandler authenticationFailureHandler = new DefaultAuthenticationFailureHandler();
    private RequestMatcher loginRequestMatcher;
    private AuthenticationManager authenticationManager;
    private AuditCallback auditCallback;
    private MessageProvider messageProvider = new DefaultMessageProvider();

    public LoginEndpoint() {
        this.loginRequestMatcher = new AntPathRequestMatcher("/token/login");
    }

    public LoginEndpoint(String loginFilterProcessesUrl) {
        this.loginRequestMatcher = new AntPathRequestMatcher(loginFilterProcessesUrl);
    }

    public LoginEndpoint(RequestMatcher loginRequestMatcher) {
        Assert.notNull((Object)loginRequestMatcher, (String)"loginRequestMatcher cannot be null");
        this.loginRequestMatcher = loginRequestMatcher;
    }

    public void setLoginProcessesUrl(String loginFilterProcessesUrl) {
        this.loginRequestMatcher = new AntPathRequestMatcher(loginFilterProcessesUrl);
    }

    public final void setLoginRequestMatcher(RequestMatcher loginRequestMatcher) {
        Assert.notNull((Object)loginRequestMatcher, (String)"loginRequestMatcher cannot be null");
        this.loginRequestMatcher = loginRequestMatcher;
    }

    public String getUsernameParameter() {
        return this.usernameParameter;
    }

    public void setUsernameParameter(String usernameParameter) {
        this.usernameParameter = usernameParameter;
    }

    public String getPasswordParameter() {
        return this.passwordParameter;
    }

    public void setPasswordParameter(String passwordParameter) {
        this.passwordParameter = passwordParameter;
    }

    public boolean isPostOnly() {
        return this.postOnly;
    }

    public void setPostOnly(boolean postOnly) {
        this.postOnly = postOnly;
    }

    public AuthenticationSuccessHandler getAuthenticationSuccessHandler() {
        return this.authenticationSuccessHandler;
    }

    public void setAuthenticationSuccessHandler(AuthenticationSuccessHandler authenticationSuccessHandler) {
        this.authenticationSuccessHandler = authenticationSuccessHandler;
    }

    public AuthenticationFailureHandler getAuthenticationFailureHandler() {
        return this.authenticationFailureHandler;
    }

    public void setAuthenticationFailureHandler(AuthenticationFailureHandler authenticationFailureHandler) {
        this.authenticationFailureHandler = authenticationFailureHandler;
    }

    public AuthenticationManager getAuthenticationManager() {
        return this.authenticationManager;
    }

    public void setAuthenticationManager(AuthenticationManager authenticationManager) {
        this.authenticationManager = authenticationManager;
    }

    public AuditCallback getAuditCallback() {
        return this.auditCallback;
    }

    public void setAuditCallback(AuditCallback auditCallback) {
        Assert.notNull((Object)auditCallback, (String)"auditCallback cannot be null");
        this.auditCallback = auditCallback;
    }

    public MessageProvider getMessageProvider() {
        return this.messageProvider;
    }

    public void setMessageProvider(MessageProvider messageProvider) {
        this.messageProvider = messageProvider;
    }

    public final void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws ServletException, IOException {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        if (this.isLoginMatched(request, response)) {
            this.doLogin(request, response, chain);
        } else {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
    }

    private void doLogin(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        try {
            if (this.postOnly && !"POST".equals(request.getMethod())) {
                throw new AuthenticationException("Authentication method not supported: " + request.getMethod());
            }
            String username = this.obtainUsername(request);
            String password = this.obtainPassword(request);
            if (username == null || StringUtils.isEmpty((Object)username)) {
                throw new AuthenticationFailureException(this.messageProvider.getMessage("error.usernameRequired"));
            }
            if (password == null || StringUtils.isEmpty((Object)password)) {
                throw new AuthenticationFailureException(this.messageProvider.getMessage("error.passwordRequired"));
            }
            username = username.trim();
            UsernamePasswordAuthenticationRequest authRequest = new UsernamePasswordAuthenticationRequest(username, password);
            Authentication authentication = this.authenticationManager.login(authRequest);
            this.authenticationSuccessHandler.onAuthenticationSuccess(request, response, authentication);
            if (this.auditCallback != null) {
                try {
                    this.auditCallback.auditLogin(request, true);
                }
                catch (Throwable e) {}
            }
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
            if (this.auditCallback != null) {
                try {
                    this.auditCallback.auditLogin(request, false);
                }
                catch (Throwable e1) {
                    // empty catch block
                }
            }
            this.authenticationFailureHandler.handle(request, response, e);
        }
    }

    protected String obtainUsername(HttpServletRequest request) {
        return request.getParameter(this.usernameParameter);
    }

    protected String obtainPassword(HttpServletRequest request) {
        return request.getParameter(this.passwordParameter);
    }

    protected boolean isLoginMatched(HttpServletRequest request, HttpServletResponse response) {
        return this.loginRequestMatcher.matches(request);
    }

    public void afterPropertiesSet() {
        Assert.notNull((Object)this.authenticationManager, (String)"authenticationManager must be specified");
    }
}

