/*
 * Decompiled with CFR 0.152.
 */
package in.clouthink.daas.security.token.core.acl;

import in.clouthink.daas.security.token.core.acl.UrlMatcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RegexUrlMatcher
implements UrlMatcher {
    private static final Log logger = LogFactory.getLog(RegexUrlMatcher.class);
    private final Pattern pattern;
    private final String[] httpMethods;

    public RegexUrlMatcher(String pattern) {
        this(pattern, "*", false);
    }

    public RegexUrlMatcher(String pattern, String ... httpMethods) {
        this(pattern, httpMethods, false);
    }

    public RegexUrlMatcher(String pattern, String httpMethod, boolean caseInsensitive) {
        this(pattern, new String[]{httpMethod}, caseInsensitive);
    }

    public RegexUrlMatcher(String pattern, String[] httpMethods, boolean caseInsensitive) {
        String[] stringArray;
        this.pattern = caseInsensitive ? Pattern.compile(pattern, 2) : Pattern.compile(pattern);
        if (httpMethods == null || httpMethods.length == 0) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "*";
        } else {
            stringArray = httpMethods;
        }
        this.httpMethods = stringArray;
    }

    @Override
    public boolean matches(String url, String httpMethod) {
        if (httpMethod != null) {
            boolean httpMethodMatched = false;
            for (String hm : this.httpMethods) {
                if ("*".equalsIgnoreCase(hm)) {
                    httpMethodMatched = true;
                    break;
                }
                if (!hm.equalsIgnoreCase(httpMethod)) continue;
                httpMethodMatched = true;
                break;
            }
            if (!httpMethodMatched) {
                return false;
            }
        }
        return this.pattern.matcher(url).matches();
    }
}

