/*
 * Decompiled with CFR 0.152.
 */
package in.clouthink.daas.security.token.spi.impl.redis;

import in.clouthink.daas.security.token.core.Token;
import in.clouthink.daas.security.token.core.User;
import in.clouthink.daas.security.token.spi.TokenProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;

public class TokenProviderRedisImpl
implements TokenProvider<Token> {
    public static final Log logger = LogFactory.getLog(TokenProviderRedisImpl.class);
    @Autowired
    private RedisTemplate<String, Token> redisTemplateToken;
    @Autowired
    private RedisTemplate<String, String> redisTemplateSet;

    @Override
    public void saveToken(Token token) {
        logger.debug((Object)String.format("Put T:%s expiredAt:%s", token.getToken(), token.getExpiredDate()));
        this.redisTemplateToken.opsForHash().put((Object)("T:" + token.getToken()), (Object)token.getToken(), (Object)token);
        this.redisTemplateToken.expireAt((Object)("T:" + token.getToken()), token.getExpiredDate());
        if (token.getOwner() == null) {
            return;
        }
        this.redisTemplateSet.opsForSet().add((Object)("U:" + token.getOwner().getUsername()), (Object[])new String[]{token.getToken()});
        this.redisTemplateToken.expireAt((Object)("U:" + token.getOwner().getUsername()), token.getExpiredDate());
    }

    @Override
    public Token findByToken(String token) {
        logger.debug((Object)String.format("Get T:%s", token));
        return (Token)this.redisTemplateToken.opsForHash().get((Object)("T:" + token), (Object)token);
    }

    @Override
    public void revokeToken(Token token) {
        logger.debug((Object)String.format("Del T:%s", token));
        if (token == null) {
            return;
        }
        this.redisTemplateToken.opsForHash().delete((Object)("T:" + token.getToken()), new Object[]{token.getToken()});
        if (token.getOwner() == null) {
            return;
        }
        this.redisTemplateSet.opsForSet().remove((Object)("U:" + token.getOwner().getUsername()), new Object[]{token.getToken()});
    }

    @Override
    public List<Token> findByUser(User user) {
        if (user == null) {
            return null;
        }
        ArrayList<Token> result = new ArrayList<Token>();
        Set tokens = this.redisTemplateSet.opsForSet().members((Object)("U:" + user.getUsername()));
        for (String token : tokens) {
            Token t = this.findByToken(token);
            if (t == null) continue;
            result.add(t);
        }
        return result;
    }
}

