/*
 * Decompiled with CFR 0.152.
 */
package in.clouthink.daas.security.token.spi.impl;

import in.clouthink.daas.security.token.core.pwd.DefaultPasswordDigester;
import in.clouthink.daas.security.token.core.pwd.PasswordDigester;
import in.clouthink.daas.security.token.exception.UnsupportedDigestAlgorithmException;
import in.clouthink.daas.security.token.spi.PasswordDigesterProvider;

public class DefaultPasswordDigesterProvider
implements PasswordDigesterProvider {
    private PasswordDigester md5digester = new DefaultPasswordDigester("MD5");
    private PasswordDigester sha1digester = new DefaultPasswordDigester("SHA1");
    private PasswordDigester sha256digester = new DefaultPasswordDigester("SHA256");

    @Override
    public PasswordDigester getPasswordDigester(String digestAlgorithm) {
        if ("MD5".equalsIgnoreCase(digestAlgorithm)) {
            return this.md5digester;
        }
        if ("SHA1".equalsIgnoreCase(digestAlgorithm)) {
            return this.sha1digester;
        }
        if ("SHA256".equalsIgnoreCase(digestAlgorithm)) {
            return this.sha256digester;
        }
        throw new UnsupportedDigestAlgorithmException(digestAlgorithm);
    }
}

