/*
 * Decompiled with CFR 0.152.
 */
package in.clouthink.daas.security.token.spi.impl.memcached;

import in.clouthink.daas.security.token.core.Token;
import in.clouthink.daas.security.token.core.User;
import in.clouthink.daas.security.token.spi.TokenProvider;
import java.util.Collections;
import java.util.List;
import net.spy.memcached.MemcachedClient;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class TokenProviderMemcachedImpl
implements TokenProvider<Token> {
    public static final Log logger = LogFactory.getLog(TokenProviderMemcachedImpl.class);
    @Autowired
    private MemcachedClient memcachedClient;

    @Override
    public void saveToken(Token token) {
        logger.debug((Object)String.format("Put token:%s expiredAt:%s", token.getToken(), token.getExpiredDate()));
        this.memcachedClient.add(token.getToken(), (int)((token.getExpiredDate().getTime() - System.currentTimeMillis()) / 1000L), (Object)token);
    }

    @Override
    public Token findByToken(String token) {
        logger.debug((Object)String.format("Get token:%s", token));
        return (Token)this.memcachedClient.get(token);
    }

    @Override
    public void revokeToken(Token token) {
        logger.debug((Object)String.format("Del token:%s", token));
        if (token == null) {
            return;
        }
        this.memcachedClient.delete(token.getToken());
    }

    @Override
    public List<Token> findByUser(User user) {
        return Collections.EMPTY_LIST;
    }
}

