/*
 * Decompiled with CFR 0.152.
 */
package in.clouthink.daas.security.token.core;

import in.clouthink.daas.security.token.core.Token;
import in.clouthink.daas.security.token.core.TokenLifeSupport;
import in.clouthink.daas.security.token.core.TokenManager;
import in.clouthink.daas.security.token.core.User;
import in.clouthink.daas.security.token.spi.TokenProvider;
import in.clouthink.daas.security.token.spi.impl.model.TokenEntity;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;

public class DefaultTokenManager
implements TokenManager,
TokenLifeSupport,
InitializingBean {
    private TokenProvider tokenProvider;
    private short maxAllowedTokenPerUser = (short)3;
    private long tokenTimeout = 3600000L;
    private long refreshTokenInteval = 180000L;
    private boolean allowedMultiTokens = true;

    public long getTokenTimeout() {
        return this.tokenTimeout;
    }

    @Override
    public void setTokenTimeout(long tokenTimeout) {
        this.tokenTimeout = tokenTimeout;
    }

    public long getRefreshTokenInteval() {
        return this.refreshTokenInteval;
    }

    @Override
    public void setRefreshTokenInteval(long refreshTokenInteval) {
        this.refreshTokenInteval = refreshTokenInteval;
    }

    @Autowired
    public TokenProvider getTokenProvider() {
        return this.tokenProvider;
    }

    public void setTokenProvider(TokenProvider tokenProvider) {
        this.tokenProvider = tokenProvider;
    }

    @Override
    public void refreshToken(Token token) {
        if (null == token.getLatestTime()) {
            token.updateExpiredDate(this.tokenTimeout);
            this.tokenProvider.saveToken(token);
            return;
        }
        long lastTime = token.getLatestTime().getTime();
        long currentTimeMillis = System.currentTimeMillis();
        if (currentTimeMillis - lastTime > this.refreshTokenInteval) {
            token.updateExpiredDate(this.tokenTimeout);
            this.tokenProvider.saveToken(token);
        }
    }

    @Override
    public Token createToken(User owner) {
        List tokens;
        if (!this.allowedMultiTokens && (tokens = this.tokenProvider.findByUser(owner)) != null) {
            int existedTokenCount = tokens.size();
            if (existedTokenCount > this.maxAllowedTokenPerUser - 1) {
                Collections.sort(tokens, new Comparator<Token>(){

                    @Override
                    public int compare(Token o1, Token o2) {
                        if (o1.getExpiredDate() != null && o2.getExpiredDate() != null) {
                            long o2expiredTimestamp;
                            long o1expiredTimestamp = o1.getExpiredDate().getTime();
                            if (o1expiredTimestamp == (o2expiredTimestamp = o2.getExpiredDate().getTime())) {
                                return 0;
                            }
                            return o1expiredTimestamp > o2expiredTimestamp ? -1 : 1;
                        }
                        return 0;
                    }
                });
                for (int i = 0; i < existedTokenCount; ++i) {
                    Token token = (Token)tokens.get(i);
                    if (i < this.maxAllowedTokenPerUser - 1) {
                        token.disable();
                        this.tokenProvider.saveToken(token);
                        continue;
                    }
                    this.tokenProvider.revokeToken(token);
                }
            } else {
                for (Token token : tokens) {
                    token.disable();
                    this.tokenProvider.saveToken(token);
                }
            }
        }
        TokenEntity token = TokenEntity.create(owner, this.tokenTimeout);
        this.tokenProvider.saveToken(token);
        return token;
    }

    @Override
    public Token findToken(String token) {
        Object result = this.tokenProvider.findByToken(token);
        if (result == null) {
            return null;
        }
        if (result.getExpiredDate().getTime() < System.currentTimeMillis()) {
            this.tokenProvider.revokeToken(result);
            return null;
        }
        return result;
    }

    @Override
    public void revokeToken(String token) {
        this.tokenProvider.revokeToken(this.findToken(token));
    }

    @Override
    public boolean isMultiTokensAllowed() {
        return this.allowedMultiTokens;
    }

    @Override
    public void enableMultiTokens() {
        this.allowedMultiTokens = true;
    }

    @Override
    public void disableMultiTokens() {
        this.allowedMultiTokens = false;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.tokenProvider);
    }
}

