/*
 * Decompiled with CFR 0.152.
 */
package in.clouthink.daas.security.token.core.acl;

import in.clouthink.daas.security.token.core.User;
import in.clouthink.daas.security.token.core.acl.AbstractAccessRequestVoter;
import in.clouthink.daas.security.token.core.acl.AccessRequest;
import in.clouthink.daas.security.token.core.acl.AccessRequestRoleVoter;
import in.clouthink.daas.security.token.core.acl.AccessResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AccessRequestUserVoter<T extends AccessRequest>
extends AbstractAccessRequestVoter<T> {
    private static final Log logger = LogFactory.getLog(AccessRequestRoleVoter.class);

    @Override
    public AccessResponse vote(T t, String grantRule) {
        AccessResponse result = this.doVote(t, grantRule);
        logger.debug((Object)("Vote result:" + (Object)((Object)result)));
        return result;
    }

    private AccessResponse doVote(T t, String grantRule) {
        if (this.isMatched(grantRule)) {
            String rule = this.getRuleBody(grantRule);
            User user = t.getAuthentication().currentToken().getOwner();
            if (this.isCaseInsensitive() ? user.getUsername().equalsIgnoreCase(rule) : user.getUsername().equals(rule)) {
                return AccessResponse.APPROVED;
            }
        }
        return AccessResponse.ABANDON;
    }

    boolean isMatched(String grantRule) {
        return grantRule.startsWith("USERNAME:");
    }

    String getRuleBody(String grantRule) {
        return grantRule.substring("USERNAME:".length());
    }
}

