/*
 * Decompiled with CFR 0.152.
 */
package in.clouthink.daas.security.token.spi.impl;

import in.clouthink.daas.security.token.core.Authentication;
import in.clouthink.daas.security.token.core.AuthenticationRequest;
import in.clouthink.daas.security.token.core.DefaultAuthentication;
import in.clouthink.daas.security.token.core.Token;
import in.clouthink.daas.security.token.core.TokenManager;
import in.clouthink.daas.security.token.core.User;
import in.clouthink.daas.security.token.core.UsernamePasswordAuthenticationRequest;
import in.clouthink.daas.security.token.core.pwd.PasswordDigester;
import in.clouthink.daas.security.token.exception.BadCredetialException;
import in.clouthink.daas.security.token.exception.UserDisabledException;
import in.clouthink.daas.security.token.exception.UserExpiredException;
import in.clouthink.daas.security.token.exception.UserLockedException;
import in.clouthink.daas.security.token.exception.UserNotFoundException;
import in.clouthink.daas.security.token.spi.AuthenticationProvider;
import in.clouthink.daas.security.token.spi.DigestMetadataProvider;
import in.clouthink.daas.security.token.spi.IdentityProvider;
import in.clouthink.daas.security.token.spi.PasswordDigesterProvider;
import in.clouthink.daas.security.token.spi.impl.DefaultPasswordDigesterProvider;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;

public class UsernamePasswordAuthenticationProvider
implements AuthenticationProvider<UsernamePasswordAuthenticationRequest>,
InitializingBean {
    private PasswordDigesterProvider passwordDigesterProvider = new DefaultPasswordDigesterProvider();
    private IdentityProvider identityProvider;
    private TokenManager tokenManager;
    private DigestMetadataProvider digestMetadataProvider = DigestMetadataProvider.INSTANCE;

    public PasswordDigesterProvider getPasswordDigesterProvider() {
        return this.passwordDigesterProvider;
    }

    @Autowired(required=false)
    public void setPasswordDigesterProvider(PasswordDigesterProvider passwordDigesterProvider) {
        this.passwordDigesterProvider = passwordDigesterProvider;
    }

    public void setIdentityProvider(IdentityProvider identityProvider) {
        this.identityProvider = identityProvider;
    }

    public TokenManager getTokenManager() {
        return this.tokenManager;
    }

    public void setTokenManager(TokenManager tokenManager) {
        this.tokenManager = tokenManager;
    }

    public DigestMetadataProvider getDigestMetadataProvider() {
        return this.digestMetadataProvider;
    }

    @Autowired(required=false)
    public void setDigestMetadataProvider(DigestMetadataProvider digestMetadataProvider) {
        this.digestMetadataProvider = digestMetadataProvider;
    }

    public IdentityProvider getIdentityProvider() {
        return this.identityProvider;
    }

    @Override
    public boolean supports(AuthenticationRequest request) {
        return request instanceof UsernamePasswordAuthenticationRequest;
    }

    @Override
    public Authentication authenticate(UsernamePasswordAuthenticationRequest usernamePasswordAuthenticationRequest) {
        String username = usernamePasswordAuthenticationRequest.getPrincipal();
        String password = usernamePasswordAuthenticationRequest.getCredentials();
        Object user = this.identityProvider.findByUsername(username);
        if (user == null) {
            throw new UserNotFoundException(username);
        }
        if (user.isExpired()) {
            throw new UserExpiredException();
        }
        if (user.isLocked()) {
            throw new UserLockedException();
        }
        if (!user.isEnabled()) {
            throw new UserDisabledException();
        }
        String encodedPassword = user.getPassword();
        String digestAlgorithm = this.digestMetadataProvider.getDigestAlgorithm(user);
        String salt = this.digestMetadataProvider.getSalt(user);
        PasswordDigester passwordDigester = this.passwordDigesterProvider.getPasswordDigester(digestAlgorithm);
        if (!passwordDigester.matches(password, encodedPassword, salt)) {
            throw new BadCredetialException();
        }
        Token token = this.tokenManager.createToken((User)user);
        return new DefaultAuthentication(token);
    }

    @Override
    public void revoke(Authentication authentication) {
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.identityProvider);
        Assert.notNull((Object)this.tokenManager);
    }
}

