/*
 * Decompiled with CFR 0.152.
 */
package in.clouthink.daas.security.token.annotation;

import in.clouthink.daas.security.token.annotation.EnableToken;
import in.clouthink.daas.security.token.configure.TokenConfigurer;
import in.clouthink.daas.security.token.configure.TokenConfigurerAdapter;
import in.clouthink.daas.security.token.configure.UrlAclProviderBuilder;
import in.clouthink.daas.security.token.core.AuthenticationManager;
import in.clouthink.daas.security.token.core.AuthorizationManager;
import in.clouthink.daas.security.token.core.DefaultAuthenticationManager;
import in.clouthink.daas.security.token.core.DefaultAuthorizationManager;
import in.clouthink.daas.security.token.core.DefaultTokenManager;
import in.clouthink.daas.security.token.core.TokenManager;
import in.clouthink.daas.security.token.core.acl.AccessRequestRoleVoter;
import in.clouthink.daas.security.token.core.acl.AccessRequestUserVoter;
import in.clouthink.daas.security.token.federation.DefaultFederationService;
import in.clouthink.daas.security.token.federation.FederationService;
import in.clouthink.daas.security.token.spi.AclProvider;
import in.clouthink.daas.security.token.spi.AuthenticationProvider;
import in.clouthink.daas.security.token.spi.AuthorizationProvider;
import in.clouthink.daas.security.token.spi.FederationProvider;
import in.clouthink.daas.security.token.spi.IdentityProvider;
import in.clouthink.daas.security.token.spi.TokenProvider;
import in.clouthink.daas.security.token.spi.impl.DefaultUrlAuthorizationProvider;
import in.clouthink.daas.security.token.spi.impl.SimpleFederationProvider;
import in.clouthink.daas.security.token.spi.impl.TokenAuthenticationProvider;
import in.clouthink.daas.security.token.spi.impl.UsernamePasswordAuthenticationProvider;
import in.clouthink.daas.security.token.spi.impl.memory.IdentityProviderMemoryImpl;
import in.clouthink.daas.security.token.spi.impl.memory.TokenProviderMemoryImpl;
import in.clouthink.daas.security.token.support.i18n.DefaultMessageProvider;
import in.clouthink.daas.security.token.support.i18n.MessageProvider;
import in.clouthink.daas.security.token.support.web.AuthenticationFilter;
import in.clouthink.daas.security.token.support.web.AuthorizationFilter;
import in.clouthink.daas.security.token.support.web.DefaultAuthenticationFailureHandler;
import in.clouthink.daas.security.token.support.web.DefaultAuthorizationFailureHandler;
import in.clouthink.daas.security.token.support.web.LoginEndpoint;
import in.clouthink.daas.security.token.support.web.LogoutEndpoint;
import in.clouthink.daas.security.token.support.web.PreAuthenticationFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.context.annotation.ImportAware;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.web.filter.CompositeFilter;
import org.springframework.web.filter.GenericFilterBean;

@Configuration
public class TokenConfiguration
implements ImportAware,
BeanFactoryAware {
    public static final String DAAS_TOKEN_FILTER = "daasTokenFilter";
    protected ListableBeanFactory beanFactory;
    protected BeanDefinitionRegistry beanDefinitionRegistry;
    protected AnnotationAttributes enableToken;
    protected TokenConfigurer tokenConfigurer = new TokenConfigurerAdapter();

    public void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = (ListableBeanFactory)beanFactory;
        this.beanDefinitionRegistry = (BeanDefinitionRegistry)beanFactory;
    }

    @Autowired(required=false)
    void setConfigurers(Collection<TokenConfigurer> configurers) {
        TokenConfigurer configurer;
        if (CollectionUtils.isEmpty(configurers)) {
            return;
        }
        if (configurers.size() > 1) {
            throw new IllegalStateException("Only one TokenConfigurer may exist");
        }
        this.tokenConfigurer = configurer = configurers.iterator().next();
    }

    public void setImportMetadata(AnnotationMetadata importMetadata) {
        this.enableToken = AnnotationAttributes.fromMap((Map)importMetadata.getAnnotationAttributes(EnableToken.class.getName(), false));
        Assert.notNull((Object)this.enableToken, (String)("@EnableJwt is not present on importing class " + importMetadata.getClassName()));
    }

    @Bean(name={"daasTokenFilter"})
    @Autowired
    public CompositeFilter daasTokenCompositeFilter(PreAuthenticationFilter preAuthenticationFilter, AuthenticationFilter authenticationFilter, AuthorizationFilter authorizationFilter, LoginEndpoint loginEndpoint, LogoutEndpoint logoutEndpoint) {
        ArrayList<GenericFilterBean> filters = new ArrayList<GenericFilterBean>();
        this.tokenConfigurer.configure(preAuthenticationFilter);
        this.tokenConfigurer.configure(authenticationFilter);
        this.tokenConfigurer.configure(authorizationFilter);
        this.tokenConfigurer.configure(loginEndpoint);
        this.tokenConfigurer.configure(logoutEndpoint);
        filters.add(loginEndpoint);
        filters.add(logoutEndpoint);
        filters.add(preAuthenticationFilter);
        filters.add(authenticationFilter);
        filters.add(authorizationFilter);
        CompositeFilter result = new CompositeFilter();
        result.setFilters(filters);
        return result;
    }

    @Bean
    @Autowired
    @DependsOn(value={"daasDefaultAuthenticationManager"})
    public PreAuthenticationFilter daasTokenPreAuthenticationFilter(AuthenticationManager authenticationManager, MessageProvider messageProvider) {
        PreAuthenticationFilter result = new PreAuthenticationFilter();
        result.setAuthenticationManager(authenticationManager);
        result.setAuthorizationFailureHandler(new DefaultAuthorizationFailureHandler(messageProvider));
        return result;
    }

    @Bean
    @Autowired
    @DependsOn(value={"daasDefaultAuthenticationManager"})
    public AuthenticationFilter daasTokenAuthenticationFilter(AuthenticationManager authenticationManager, MessageProvider messageProvider) {
        AuthenticationFilter result = new AuthenticationFilter();
        result.setAuthorizationFailureHandler(new DefaultAuthorizationFailureHandler(messageProvider));
        return result;
    }

    @Bean
    @Autowired
    @DependsOn(value={"daasDefaultAuthorizationManager"})
    public AuthorizationFilter daasTokenAuthorizationFilter(AuthorizationManager authorizationManager, MessageProvider messageProvider) {
        AuthorizationFilter result = new AuthorizationFilter();
        result.setAuthorizationManager(authorizationManager);
        result.setAuthorizationFailureHandler(new DefaultAuthorizationFailureHandler(messageProvider));
        return result;
    }

    @Bean
    @Autowired
    @DependsOn(value={"daasDefaultAuthenticationManager"})
    public LoginEndpoint daasTokenLoginEndpoint(AuthenticationManager authenticationManager, MessageProvider messageProvider) {
        LoginEndpoint result = new LoginEndpoint();
        result.setAuthenticationManager(authenticationManager);
        result.setAuthenticationFailureHandler(new DefaultAuthenticationFailureHandler(messageProvider));
        return result;
    }

    @Bean
    @Autowired
    @DependsOn(value={"daasDefaultAuthenticationManager"})
    public LogoutEndpoint daasTokenLogoutEndpoint(AuthenticationManager authenticationManager, MessageProvider messageProvider) {
        LogoutEndpoint result = new LogoutEndpoint();
        result.setAuthenticationManager(authenticationManager);
        result.setAuthorizationFailureHandler(new DefaultAuthorizationFailureHandler(messageProvider));
        return result;
    }

    @Bean
    @Autowired
    @DependsOn(value={"daasUsernamePasswordAuthenticationProvider", "daasTokenAuthenticationProvider"})
    public AuthenticationManager daasDefaultAuthenticationManager(IdentityProvider identityProvider, TokenManager tokenManager) {
        DefaultAuthenticationManager result = new DefaultAuthenticationManager();
        result.addProvider(this.daasUsernamePasswordAuthenticationProvider(identityProvider, tokenManager));
        result.addProvider(this.daasTokenAuthenticationProvider(identityProvider, tokenManager));
        return result;
    }

    @Bean
    @Autowired
    @DependsOn(value={"daasSimpleFederationProvider", "daasTokenAuthenticationProvider"})
    public FederationService daasDefaultFederationService(IdentityProvider identityProvider, TokenManager tokenManager) {
        DefaultFederationService result = new DefaultFederationService();
        result.addProvider(this.daasSimpleFederationProvider(tokenManager));
        result.addProvider(this.daasTokenAuthenticationProvider(identityProvider, tokenManager));
        return result;
    }

    @Bean
    @Autowired
    public AuthorizationManager daasDefaultAuthorizationManager(AuthorizationProvider authorizationProvider) {
        DefaultAuthorizationManager result = new DefaultAuthorizationManager();
        result.getProviders().add(authorizationProvider);
        return result;
    }

    @Bean
    @Autowired
    public AuthenticationProvider daasUsernamePasswordAuthenticationProvider(IdentityProvider identityProvider, TokenManager tokenManager) {
        UsernamePasswordAuthenticationProvider result = new UsernamePasswordAuthenticationProvider();
        result.setIdentityProvider(identityProvider);
        result.setTokenManager(tokenManager);
        return result;
    }

    @Bean
    @Autowired
    public FederationProvider daasSimpleFederationProvider(TokenManager tokenManager) {
        SimpleFederationProvider result = new SimpleFederationProvider();
        result.setTokenManager(tokenManager);
        return result;
    }

    @Bean
    @Autowired
    public AuthenticationProvider daasTokenAuthenticationProvider(IdentityProvider identityProvider, TokenManager tokenManager) {
        TokenAuthenticationProvider result = new TokenAuthenticationProvider();
        result.setIdentityProvider(identityProvider);
        result.setTokenManager(tokenManager);
        return result;
    }

    @Bean
    @Autowired
    public AuthorizationProvider daasDefaultUrlAuthorizationProvider(AclProvider aclProvider) {
        DefaultUrlAuthorizationProvider result = new DefaultUrlAuthorizationProvider();
        result.getVoters().add(new AccessRequestRoleVoter());
        result.getVoters().add(new AccessRequestUserVoter());
        result.setProvider(aclProvider);
        return result;
    }

    @Bean
    @Autowired
    public TokenManager daasDefaultTokenManager(TokenProvider tokenProvider) {
        DefaultTokenManager tokenManager = new DefaultTokenManager();
        tokenManager.setTokenProvider(tokenProvider);
        this.tokenConfigurer.configure(tokenManager);
        return tokenManager;
    }

    @Bean
    public AclProvider daasDefaultUrlAclProvider() {
        UrlAclProviderBuilder urlAclProviderBuilder = UrlAclProviderBuilder.newInstance();
        this.tokenConfigurer.configure(urlAclProviderBuilder);
        return urlAclProviderBuilder.build();
    }

    @Bean
    public TokenProvider daasDefaultTokenProvider() {
        return new TokenProviderMemoryImpl();
    }

    @Bean
    public IdentityProvider daasDefaultIdentityProvider() {
        return new IdentityProviderMemoryImpl();
    }

    @Bean
    public MessageProvider messageProvider() {
        DefaultMessageProvider result = new DefaultMessageProvider();
        this.tokenConfigurer.configure(result);
        return result;
    }
}

