/*
 * Decompiled with CFR 0.152.
 */
package in.clouthink.daas.security.token.core.acl;

import in.clouthink.daas.security.token.core.acl.UrlMatcher;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.AntPathMatcher;

public class AntPathUrlMatcher
implements UrlMatcher {
    private static final Log logger = LogFactory.getLog(AntPathUrlMatcher.class);
    private static final String MATCH_ALL = "/**";
    private String pattern;
    private Matcher matcher;
    private String[] httpMethods;
    private boolean caseSensitive;

    public AntPathUrlMatcher(String pattern) {
        this(pattern, "*", false);
    }

    public AntPathUrlMatcher(String pattern, String ... httpMethods) {
        this(pattern, httpMethods, false);
    }

    public AntPathUrlMatcher(String pattern, String httpMethod, boolean caseInsensitive) {
        this(pattern, new String[]{httpMethod}, caseInsensitive);
    }

    public AntPathUrlMatcher(String pattern, String[] httpMethods, boolean caseInsensitive) {
        String[] stringArray;
        if (pattern.equals(MATCH_ALL) || pattern.equals("**")) {
            pattern = MATCH_ALL;
            this.matcher = null;
        } else {
            if (!this.caseSensitive) {
                pattern = pattern.toLowerCase();
            }
            this.matcher = pattern.endsWith(MATCH_ALL) && pattern.indexOf(63) == -1 && pattern.indexOf("*") == pattern.length() - 2 ? new SubpathMatcher(pattern.substring(0, pattern.length() - 3)) : new SpringAntMatcher(pattern);
        }
        this.pattern = pattern;
        if (httpMethods == null || httpMethods.length == 0) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "*";
        } else {
            stringArray = httpMethods;
        }
        this.httpMethods = stringArray;
    }

    @Override
    public boolean matches(String url, String httpMethod) {
        if (httpMethod != null) {
            boolean httpMethodMatched = false;
            for (String hm : this.httpMethods) {
                if ("*".equalsIgnoreCase(hm)) {
                    httpMethodMatched = true;
                    break;
                }
                if (!hm.equalsIgnoreCase(httpMethod)) continue;
                httpMethodMatched = true;
                break;
            }
            if (!httpMethodMatched) {
                return false;
            }
        }
        if (this.pattern.equals(MATCH_ALL)) {
            return true;
        }
        if (!this.caseSensitive) {
            return this.matcher.matches(url.toLowerCase());
        }
        return this.matcher.matches(url);
    }

    private static class SubpathMatcher
    implements Matcher {
        private final String subpath;
        private final int length;

        private SubpathMatcher(String subpath) {
            assert (!subpath.contains("*"));
            this.subpath = subpath;
            this.length = subpath.length();
        }

        @Override
        public boolean matches(String path) {
            return path.startsWith(this.subpath) && (path.length() == this.length || path.charAt(this.length) == '/');
        }
    }

    private static class SpringAntMatcher
    implements Matcher {
        private static final AntPathMatcher antMatcher = new AntPathMatcher();
        private final String pattern;

        private SpringAntMatcher(String pattern) {
            this.pattern = pattern;
        }

        @Override
        public boolean matches(String path) {
            return antMatcher.match(this.pattern, path);
        }
    }

    private static interface Matcher {
        public boolean matches(String var1);
    }
}

