/*
 * Decompiled with CFR 0.152.
 */
package in.clouthink.daas.security.token.federation;

import in.clouthink.daas.security.token.core.Authentication;
import in.clouthink.daas.security.token.event.authentication.FederationLoginEvent;
import in.clouthink.daas.security.token.event.authentication.FederationLogoutEvent;
import in.clouthink.daas.security.token.federation.FederationRequest;
import in.clouthink.daas.security.token.federation.FederationService;
import in.clouthink.daas.security.token.spi.AuthenticationProvider;
import in.clouthink.daas.security.token.spi.FederationProvider;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.util.Assert;

public class DefaultFederationService
implements FederationService,
ApplicationContextAware,
InitializingBean {
    private ApplicationContext applicationContext;
    private List<FederationProvider> federationProviders = new ArrayList<FederationProvider>();
    private List<AuthenticationProvider> authenticationProviders = new ArrayList<AuthenticationProvider>();

    public List<FederationProvider> getFederationProviders() {
        return this.federationProviders;
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void setFederationProviders(List<FederationProvider> federationProviders) {
        this.federationProviders = federationProviders;
    }

    public void addProvider(FederationProvider provider) {
        this.federationProviders.add(provider);
    }

    public void addProviders(FederationProvider ... providers) {
        for (FederationProvider provider : providers) {
            this.federationProviders.add(provider);
        }
    }

    public List<AuthenticationProvider> getAuthenticationProviders() {
        return this.authenticationProviders;
    }

    public void setAuthenticationProviders(List<AuthenticationProvider> authenticationProviders) {
        this.authenticationProviders = authenticationProviders;
    }

    public void addProvider(AuthenticationProvider provider) {
        this.authenticationProviders.add(provider);
    }

    public void addProviders(AuthenticationProvider ... providers) {
        for (AuthenticationProvider provider : providers) {
            this.authenticationProviders.add(provider);
        }
    }

    @Override
    public Authentication login(FederationRequest request) {
        if (request == null) {
            return null;
        }
        for (FederationProvider provider : this.federationProviders) {
            if (!provider.supports(request)) continue;
            try {
                Authentication result = provider.login(request);
                this.applicationContext.publishEvent((ApplicationEvent)new FederationLoginEvent(request, result));
                return result;
            }
            catch (RuntimeException e) {
                this.applicationContext.publishEvent((ApplicationEvent)new FederationLoginEvent(request, e));
                throw e;
            }
        }
        return null;
    }

    @Override
    public void logout(Authentication authentication, Object logoutRequest) {
        if (authentication == null) {
            return;
        }
        for (AuthenticationProvider provider : this.authenticationProviders) {
            provider.revoke(authentication);
        }
        this.applicationContext.publishEvent((ApplicationEvent)new FederationLogoutEvent(authentication, logoutRequest));
    }

    public void afterPropertiesSet() {
        Assert.notNull(this.federationProviders, (String)"federationProviders must be specified");
        Assert.notNull(this.authenticationProviders, (String)"authenticationProviders must be specified");
    }
}

