/*
 * Decompiled with CFR 0.152.
 */
package in.clouthink.daas.security.token.support.web;

import in.clouthink.daas.security.token.core.Authentication;
import in.clouthink.daas.security.token.core.AuthenticationManager;
import in.clouthink.daas.security.token.core.TokenAuthenticationRequest;
import in.clouthink.daas.security.token.event.authentication.HttpLogoutEvent;
import in.clouthink.daas.security.token.repackage.org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import in.clouthink.daas.security.token.repackage.org.springframework.security.web.util.matcher.RequestMatcher;
import in.clouthink.daas.security.token.spi.AuditCallback;
import in.clouthink.daas.security.token.support.web.AuthorizationFailureHandler;
import in.clouthink.daas.security.token.support.web.BearerAuthorizationHeaderTokenResolver;
import in.clouthink.daas.security.token.support.web.DefaultAuthorizationFailureHandler;
import in.clouthink.daas.security.token.support.web.TokenResolver;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.util.Assert;
import org.springframework.web.filter.GenericFilterBean;

public class LogoutEndpoint
extends GenericFilterBean
implements ApplicationContextAware {
    private static final Log logger = LogFactory.getLog(LogoutEndpoint.class);
    private static final String HEADER_AUTHORIZATION_PREFIX = "Bearer ";
    private ApplicationContext applicationContext;
    private AuthorizationFailureHandler authorizationFailureHandler = new DefaultAuthorizationFailureHandler();
    private RequestMatcher logoutRequestMatcher;
    private AuthenticationManager authenticationManager;
    private TokenResolver tokenResolver = new BearerAuthorizationHeaderTokenResolver();
    private AuditCallback auditCallback;
    private boolean useStrict = true;

    public LogoutEndpoint() {
        this.logoutRequestMatcher = new AntPathRequestMatcher("/token/logout");
    }

    public LogoutEndpoint(String logoutFilterProcessesUrl) {
        this.logoutRequestMatcher = new AntPathRequestMatcher(logoutFilterProcessesUrl);
    }

    public LogoutEndpoint(RequestMatcher logoutRequestMatcher) {
        Assert.notNull((Object)logoutRequestMatcher, (String)"logoutRequestMatcher cannot be null");
        this.logoutRequestMatcher = logoutRequestMatcher;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void setLogoutProcessesUrl(String logoutFilterProcessesUrl) {
        this.logoutRequestMatcher = new AntPathRequestMatcher(logoutFilterProcessesUrl);
    }

    public final void setLogoutRequestMatcher(RequestMatcher logoutRequestMatcher) {
        Assert.notNull((Object)logoutRequestMatcher, (String)"logoutRequestMatcher cannot be null");
        this.logoutRequestMatcher = logoutRequestMatcher;
    }

    public AuthenticationManager getAuthenticationManager() {
        return this.authenticationManager;
    }

    @Autowired
    public void setAuthenticationManager(AuthenticationManager authenticationManager) {
        this.authenticationManager = authenticationManager;
    }

    public void setAuthorizationFailureHandler(AuthorizationFailureHandler authorizationFailureHandler) {
        this.authorizationFailureHandler = authorizationFailureHandler;
    }

    public TokenResolver getTokenResolver() {
        return this.tokenResolver;
    }

    public void setTokenResolver(TokenResolver tokenResolver) {
        this.tokenResolver = tokenResolver;
    }

    public boolean isUseStrict() {
        return this.useStrict;
    }

    public void setUseStrict(boolean useStrict) {
        this.useStrict = useStrict;
    }

    public final void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws ServletException, IOException {
        logger.trace((Object)"doFilter start");
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        if (this.isLogoutMatched(request, response)) {
            logger.trace((Object)"doLogout matched");
            this.doLogout(request, response, chain);
        } else {
            logger.trace((Object)"doLogout un-matched, skip it");
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
    }

    private void doLogout(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        block5: {
            logger.trace((Object)"doLogout start");
            try {
                String tokenValue = this.tokenResolver.resolve(request, response);
                Authentication authentication = this.authenticationManager.login(new TokenAuthenticationRequest(tokenValue));
                this.authenticationManager.logout(authentication);
                if (this.auditCallback != null) {
                    try {
                        this.auditCallback.auditLogout(request);
                    }
                    catch (Throwable e1) {
                        // empty catch block
                    }
                }
                this.applicationContext.publishEvent((ApplicationEvent)new HttpLogoutEvent(authentication, request));
            }
            catch (Exception e) {
                logger.error((Object)e, (Throwable)e);
                if (!this.useStrict) break block5;
                this.authorizationFailureHandler.handle(request, response, e);
            }
        }
    }

    protected boolean isLogoutMatched(HttpServletRequest request, HttpServletResponse response) {
        return this.logoutRequestMatcher.matches(request);
    }

    public void afterPropertiesSet() {
        Assert.notNull((Object)this.authenticationManager, (String)"authenticationManager must be specified");
    }
}

