/*
 * Decompiled with CFR 0.152.
 */
package in.clouthink.daas.security.token.core;

import in.clouthink.daas.security.token.core.AuthorizationManager;
import in.clouthink.daas.security.token.core.AuthorizationStrategy;
import in.clouthink.daas.security.token.core.acl.AccessRequest;
import in.clouthink.daas.security.token.core.acl.AccessResponse;
import in.clouthink.daas.security.token.exception.AccessDeniedException;
import in.clouthink.daas.security.token.exception.AuthorizationFailureException;
import in.clouthink.daas.security.token.spi.AuthorizationProvider;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;

public class DefaultAuthorizationManager
implements AuthorizationManager {
    private AuthorizationStrategy authorizationStrategy = AuthorizationStrategy.DENY_IF_ABANDON;
    private List<AuthorizationProvider> providers = new ArrayList<AuthorizationProvider>();

    public AuthorizationStrategy getAuthorizationStrategy() {
        return this.authorizationStrategy;
    }

    public void setAuthorizationStrategy(AuthorizationStrategy authorizationStrategy) {
        this.authorizationStrategy = authorizationStrategy;
    }

    public void addAuthorizationProvider(AuthorizationProvider provider) {
        this.providers.add(provider);
    }

    public List<AuthorizationProvider> getProviders() {
        return this.providers;
    }

    @Autowired
    public void setProviders(List<AuthorizationProvider> providers) {
        this.providers = providers;
    }

    @Override
    public void authorize(AccessRequest accessRequest) {
        if (accessRequest == null) {
            return;
        }
        for (AuthorizationProvider provider : this.providers) {
            AccessResponse accessResponse = provider.authorize(accessRequest);
            if (AccessResponse.APPROVED == accessResponse) {
                return;
            }
            if (AccessResponse.REFUESD != accessResponse) continue;
            throw new AccessDeniedException();
        }
        if (AuthorizationStrategy.DENY_IF_ABANDON == this.authorizationStrategy) {
            throw new AuthorizationFailureException();
        }
    }
}

