/*
 * Decompiled with CFR 0.152.
 */
package in.clouthink.daas.security.token.core;

import in.clouthink.daas.security.token.core.AuthenticationFeature;
import in.clouthink.daas.security.token.core.ConfigFeature;

public class FeatureConfigurer {
    private AuthnConfig _authnConfig = new AuthnConfig();

    public final boolean isEnabled(AuthenticationFeature f) {
        return this._authnConfig.isEnabled(f);
    }

    public final boolean isDisabled(AuthenticationFeature f) {
        return !this._authnConfig.isEnabled(f);
    }

    public FeatureConfigurer configure(AuthenticationFeature f, boolean state) {
        this._authnConfig = state ? this._authnConfig.with(f) : this._authnConfig.without(f);
        return this;
    }

    public FeatureConfigurer enable(AuthenticationFeature feature) {
        this._authnConfig = this._authnConfig.with(feature);
        return this;
    }

    public FeatureConfigurer enable(AuthenticationFeature first, AuthenticationFeature ... f) {
        this._authnConfig = this._authnConfig.with(first, f);
        return this;
    }

    public FeatureConfigurer disable(AuthenticationFeature feature) {
        this._authnConfig = this._authnConfig.without(feature);
        return this;
    }

    public FeatureConfigurer disable(AuthenticationFeature first, AuthenticationFeature ... f) {
        this._authnConfig = this._authnConfig.without(first, f);
        return this;
    }

    static class AuthnConfig {
        protected final int _authnFeatures;

        public static <F extends Enum<F>> int collectFeatureDefaults(Class<F> enumClass) {
            int flags = 0;
            for (Enum value : (Enum[])enumClass.getEnumConstants()) {
                if (!((ConfigFeature)((Object)value)).enabledByDefault()) continue;
                flags |= ((ConfigFeature)((Object)value)).getMask();
            }
            return flags;
        }

        public AuthnConfig() {
            this._authnFeatures = AuthnConfig.collectFeatureDefaults(AuthenticationFeature.class);
        }

        public AuthnConfig(int authnFeatures) {
            this._authnFeatures = authnFeatures;
        }

        public final boolean isEnabled(AuthenticationFeature f) {
            return (this._authnFeatures & f.getMask()) != 0;
        }

        public AuthnConfig with(AuthenticationFeature feature) {
            int newAuthnFeatures = this._authnFeatures | feature.getMask();
            return newAuthnFeatures == this._authnFeatures ? this : new AuthnConfig(newAuthnFeatures);
        }

        public AuthnConfig with(AuthenticationFeature first, AuthenticationFeature ... features) {
            int newAuthnFeatures = this._authnFeatures | first.getMask();
            for (AuthenticationFeature f : features) {
                newAuthnFeatures |= f.getMask();
            }
            return newAuthnFeatures == this._authnFeatures ? this : new AuthnConfig(newAuthnFeatures);
        }

        public AuthnConfig withFeatures(AuthenticationFeature ... features) {
            int newAuthnFeatures = this._authnFeatures;
            for (AuthenticationFeature f : features) {
                newAuthnFeatures |= f.getMask();
            }
            return newAuthnFeatures == this._authnFeatures ? this : new AuthnConfig(newAuthnFeatures);
        }

        public AuthnConfig without(AuthenticationFeature feature) {
            int newAuthnFeatures = this._authnFeatures & ~feature.getMask();
            return newAuthnFeatures == this._authnFeatures ? this : new AuthnConfig(newAuthnFeatures);
        }

        public AuthnConfig without(AuthenticationFeature first, AuthenticationFeature ... features) {
            int newAuthnFeatures = this._authnFeatures & ~first.getMask();
            for (AuthenticationFeature f : features) {
                newAuthnFeatures &= ~f.getMask();
            }
            return newAuthnFeatures == this._authnFeatures ? this : new AuthnConfig(newAuthnFeatures);
        }

        public AuthnConfig withoutFeatures(AuthenticationFeature ... features) {
            int newAuthnFeatures = this._authnFeatures;
            for (AuthenticationFeature f : features) {
                newAuthnFeatures &= ~f.getMask();
            }
            return newAuthnFeatures == this._authnFeatures ? this : new AuthnConfig(newAuthnFeatures);
        }
    }
}

