/*
 * Decompiled with CFR 0.152.
 */
package in.clouthink.daas.security.token.core.acl;

import in.clouthink.daas.security.token.core.Role;
import in.clouthink.daas.security.token.core.User;
import in.clouthink.daas.security.token.core.acl.AbstractAccessRequestVoter;
import in.clouthink.daas.security.token.core.acl.AccessRequest;
import in.clouthink.daas.security.token.core.acl.AccessResponse;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AccessRequestRoleVoter<T extends AccessRequest>
extends AbstractAccessRequestVoter<T> {
    private static final Log logger = LogFactory.getLog(AccessRequestRoleVoter.class);

    @Override
    public AccessResponse vote(T t, String grantRule) {
        AccessResponse result = this.doVote(t, grantRule);
        logger.debug((Object)("Vote result:" + (Object)((Object)result)));
        return result;
    }

    private AccessResponse doVote(T t, String grantRule) {
        if (this.isMatched(grantRule)) {
            String rule = this.getRuleBody(grantRule);
            User user = t.getAuthentication().currentToken().getOwner();
            List<Role> roles = user.getRoles();
            for (Role role : roles) {
                if (!(this.isCaseInsensitive() ? role.getName().equalsIgnoreCase(rule) : role.getName().equals(rule))) continue;
                return AccessResponse.APPROVED;
            }
        }
        return AccessResponse.ABANDON;
    }

    boolean isMatched(String grantRule) {
        return grantRule.startsWith("ROLE:");
    }

    String getRuleBody(String grantRule) {
        return grantRule.substring("ROLE:".length());
    }
}

