/*
 * Decompiled with CFR 0.152.
 */
package in.clouthink.daas.security.token.repackage.org.springframework.security.web.util.matcher;

import in.clouthink.daas.security.token.repackage.org.springframework.security.web.util.matcher.RequestMatcher;
import javax.servlet.http.HttpServletRequest;
import org.springframework.util.Assert;

public final class RequestHeaderRequestMatcher
implements RequestMatcher {
    private final String expectedHeaderName;
    private final String expectedHeaderValue;

    public RequestHeaderRequestMatcher(String expectedHeaderName) {
        this(expectedHeaderName, null);
    }

    public RequestHeaderRequestMatcher(String expectedHeaderName, String expectedHeaderValue) {
        Assert.notNull((Object)expectedHeaderName, (String)"headerName cannot be null");
        this.expectedHeaderName = expectedHeaderName;
        this.expectedHeaderValue = expectedHeaderValue;
    }

    @Override
    public boolean matches(HttpServletRequest request) {
        String actualHeaderValue = request.getHeader(this.expectedHeaderName);
        if (this.expectedHeaderValue == null) {
            return actualHeaderValue != null;
        }
        return this.expectedHeaderValue.equals(actualHeaderValue);
    }

    public String toString() {
        return "RequestHeaderRequestMatcher [expectedHeaderName=" + this.expectedHeaderName + ", expectedHeaderValue=" + this.expectedHeaderValue + "]";
    }
}

