/*
 * Decompiled with CFR 0.152.
 */
package in.clouthink.daas.security.token.support.web;

import in.clouthink.daas.security.token.core.Authentication;
import in.clouthink.daas.security.token.core.AuthenticationFeature;
import in.clouthink.daas.security.token.core.AuthenticationManager;
import in.clouthink.daas.security.token.core.FeatureConfigurer;
import in.clouthink.daas.security.token.core.SecurityContextManager;
import in.clouthink.daas.security.token.core.TokenAuthenticationRequest;
import in.clouthink.daas.security.token.repackage.org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import in.clouthink.daas.security.token.repackage.org.springframework.security.web.util.matcher.RequestMatcher;
import in.clouthink.daas.security.token.support.web.AuthorizationFailureHandler;
import in.clouthink.daas.security.token.support.web.BearerAuthorizationHeaderTokenResolver;
import in.clouthink.daas.security.token.support.web.DefaultAuthorizationFailureHandler;
import in.clouthink.daas.security.token.support.web.TokenResolver;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.Ordered;
import org.springframework.util.Assert;
import org.springframework.web.filter.GenericFilterBean;

public class PreAuthenticationFilter
extends GenericFilterBean
implements Ordered {
    private static final Log logger = LogFactory.getLog(PreAuthenticationFilter.class);
    private int order = -2147483645;
    private TokenResolver tokenResolver = new BearerAuthorizationHeaderTokenResolver();
    private AuthorizationFailureHandler authorizationFailureHandler = new DefaultAuthorizationFailureHandler();
    private RequestMatcher urlRequestMatcher;
    private AuthenticationManager authenticationManager;
    private FeatureConfigurer featureConfigurer;

    public PreAuthenticationFilter() {
        this.urlRequestMatcher = new AntPathRequestMatcher("/api**");
    }

    public PreAuthenticationFilter(String filterProcessesUrl) {
        this.urlRequestMatcher = new AntPathRequestMatcher(filterProcessesUrl);
    }

    public PreAuthenticationFilter(RequestMatcher urlRequestMatcher) {
        this.urlRequestMatcher = urlRequestMatcher;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public int getOrder() {
        return this.order;
    }

    public void setProcessesUrl(String filterProcessesUrl) {
        this.urlRequestMatcher = new AntPathRequestMatcher(filterProcessesUrl);
    }

    public final void setUrlRequestMatcher(RequestMatcher urlRequestMatcher) {
        Assert.notNull((Object)urlRequestMatcher, (String)"urlRequestMatcher cannot be null");
        this.urlRequestMatcher = urlRequestMatcher;
    }

    public TokenResolver getTokenResolver() {
        return this.tokenResolver;
    }

    public void setTokenResolver(TokenResolver tokenResolver) {
        this.tokenResolver = tokenResolver;
    }

    public AuthorizationFailureHandler getAuthorizationFailureHandler() {
        return this.authorizationFailureHandler;
    }

    public void setAuthorizationFailureHandler(AuthorizationFailureHandler authorizationFailureHandler) {
        this.authorizationFailureHandler = authorizationFailureHandler;
    }

    public void setFeatureConfigurer(FeatureConfigurer featureConfigurer) {
        this.featureConfigurer = featureConfigurer;
    }

    public RequestMatcher getUrlRequestMatcher() {
        return this.urlRequestMatcher;
    }

    public AuthenticationManager getAuthenticationManager() {
        return this.authenticationManager;
    }

    public void setAuthenticationManager(AuthenticationManager authenticationManager) {
        this.authenticationManager = authenticationManager;
    }

    public final void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws ServletException, IOException {
        logger.trace((Object)"doFilter start");
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        if (this.isUrlProcessingMatched(request, response) && !this.isPreFlightRequest(request)) {
            logger.trace((Object)"doPreAuthentication matched");
            this.doPreAuthentication(request, response, chain);
        } else {
            logger.trace((Object)"doPreAuthentication un-matched, skip it");
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doPreAuthentication(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        logger.trace((Object)"doPreAuthentication start");
        try {
            block12: {
                String tokenValue;
                block11: {
                    tokenValue = null;
                    try {
                        tokenValue = this.tokenResolver.resolve(request, response);
                    }
                    catch (Exception e) {
                        logger.trace((Object)"tokenResolver#resolve failed");
                        if (!this.featureConfigurer.isEnabled(AuthenticationFeature.STRICT_TOKEN)) break block11;
                        logger.error((Object)e, (Throwable)e);
                        this.authorizationFailureHandler.handle(request, response, e);
                        SecurityContextManager.clearContext();
                        return;
                    }
                }
                if (tokenValue == null) {
                    logger.trace((Object)"token is null, skip authenticating token");
                    chain.doFilter((ServletRequest)request, (ServletResponse)response);
                    return;
                }
                try {
                    Authentication authentication = this.authenticationManager.login(new TokenAuthenticationRequest(tokenValue));
                    SecurityContextManager.getContext().setAuthentication(authentication);
                }
                catch (Exception e) {
                    logger.error((Object)e, (Throwable)e);
                    if (!this.featureConfigurer.isDisabled(AuthenticationFeature.IGNORE_PRE_AUTHN_ERROR)) break block12;
                    this.authorizationFailureHandler.handle(request, response, e);
                    SecurityContextManager.clearContext();
                    return;
                }
            }
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        finally {
            SecurityContextManager.clearContext();
        }
    }

    private boolean isPreFlightRequest(HttpServletRequest request) {
        return this.featureConfigurer.isEnabled(AuthenticationFeature.CORS) && "OPTIONS".equalsIgnoreCase(request.getMethod());
    }

    protected boolean isUrlProcessingMatched(HttpServletRequest request, HttpServletResponse response) {
        return this.urlRequestMatcher.matches(request);
    }

    public void afterPropertiesSet() {
        logger.trace((Object)"afterPropertiesSet");
        Assert.notNull((Object)this.featureConfigurer, (String)"featureConfigurer must be specified");
        Assert.notNull((Object)this.authenticationManager, (String)"authenticationManager must be specified");
    }
}

