/*
 * Decompiled with CFR 0.152.
 */
package in.clouthink.daas.we;

import in.clouthink.daas.we.ApplicationException;
import in.clouthink.daas.we.ErrorCode;
import in.clouthink.daas.we.ErrorCodes;
import in.clouthink.daas.we.ErrorContainer;
import in.clouthink.daas.we.FormError;
import in.clouthink.daas.we.SharedErrorCode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.ConversionNotSupportedException;
import org.springframework.beans.TypeMismatchException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.HttpMessageNotWritableException;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.validation.BindException;
import org.springframework.validation.FieldError;
import org.springframework.validation.ObjectError;
import org.springframework.web.HttpMediaTypeNotAcceptableException;
import org.springframework.web.HttpMediaTypeNotSupportedException;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.ServletRequestBindingException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.support.MissingServletRequestPartException;
import org.springframework.web.servlet.LocaleResolver;
import org.springframework.web.servlet.NoHandlerFoundException;
import org.springframework.web.servlet.mvc.multiaction.NoSuchRequestHandlingMethodException;

@ControllerAdvice(annotations={RestController.class})
public class ResponseEntityExceptionHandler
implements InitializingBean {
    protected final Log logger = LogFactory.getLog(this.getClass());
    public static final String PAGE_NOT_FOUND_LOG_CATEGORY = "org.springframework.web.servlet.PageNotFound";
    protected static final Log PAGE_NOT_FOUND_LOGGER = LogFactory.getLog((String)"org.springframework.web.servlet.PageNotFound");
    private boolean i18nEnabled = false;
    private boolean developerEnabled = false;
    @Autowired(required=false)
    private MessageSource resourceBundle;
    @Autowired(required=false)
    private LocaleResolver localeResolver;

    protected MessageSource getResourceBundle() {
        return this.resourceBundle;
    }

    public void setResourceBundle(MessageSource resourceBundle) {
        this.resourceBundle = resourceBundle;
    }

    protected LocaleResolver getLocaleResolver() {
        return this.localeResolver;
    }

    public void setLocaleResolver(LocaleResolver localeResolver) {
        this.localeResolver = localeResolver;
    }

    public boolean isI18nEnabled() {
        return this.i18nEnabled;
    }

    public void setI18nEnabled(boolean i18nEnabled) {
        this.i18nEnabled = i18nEnabled;
    }

    public boolean isDeveloperEnabled() {
        return this.developerEnabled;
    }

    public void setDeveloperEnabled(boolean developerEnabled) {
        this.developerEnabled = developerEnabled;
    }

    @ExceptionHandler(value={NoSuchRequestHandlingMethodException.class, HttpRequestMethodNotSupportedException.class, HttpMediaTypeNotSupportedException.class, HttpMediaTypeNotAcceptableException.class, MissingServletRequestParameterException.class, ServletRequestBindingException.class, ConversionNotSupportedException.class, TypeMismatchException.class, HttpMessageNotReadableException.class, HttpMessageNotWritableException.class, MissingServletRequestPartException.class, MethodArgumentNotValidException.class, BindException.class, NoHandlerFoundException.class, AccessDeniedException.class, ApplicationException.class})
    public final ResponseEntity<Object> handleException(Exception exception, HttpServletRequest request) {
        this.logger.error((Object)exception, (Throwable)exception);
        HttpHeaders headers = new HttpHeaders();
        if (exception instanceof NoSuchRequestHandlingMethodException) {
            return this.handleNoSuchRequestHandlingMethod((NoSuchRequestHandlingMethodException)exception, headers, SharedErrorCode.NOT_FOUND, request);
        }
        if (exception instanceof HttpRequestMethodNotSupportedException) {
            return this.handleHttpRequestMethodNotSupported((HttpRequestMethodNotSupportedException)exception, headers, SharedErrorCode.METHOD_NOT_ALLOWED, request);
        }
        if (exception instanceof HttpMediaTypeNotSupportedException) {
            return this.handleHttpMediaTypeNotSupported((HttpMediaTypeNotSupportedException)exception, headers, SharedErrorCode.UNSUPPORTED_MEDIA_TYPE, request);
        }
        if (exception instanceof HttpMediaTypeNotAcceptableException) {
            return this.handleHttpMediaTypeNotAcceptable((HttpMediaTypeNotAcceptableException)exception, headers, SharedErrorCode.NOT_ACCEPTABLE, request);
        }
        if (exception instanceof MissingServletRequestParameterException) {
            return this.handleMissingServletRequestParameter((MissingServletRequestParameterException)exception, headers, SharedErrorCode.BAD_REQUEST, request);
        }
        if (exception instanceof ServletRequestBindingException) {
            return this.handleServletRequestBindingException((ServletRequestBindingException)exception, headers, SharedErrorCode.BAD_REQUEST, request);
        }
        if (exception instanceof ConversionNotSupportedException) {
            return this.handleConversionNotSupported((ConversionNotSupportedException)exception, headers, SharedErrorCode.INTERNAL_SERVER_ERROR, request);
        }
        if (exception instanceof TypeMismatchException) {
            return this.handleTypeMismatch((TypeMismatchException)exception, headers, SharedErrorCode.BAD_REQUEST, request);
        }
        if (exception instanceof HttpMessageNotReadableException) {
            return this.handleHttpMessageNotReadable((HttpMessageNotReadableException)exception, headers, SharedErrorCode.BAD_REQUEST, request);
        }
        if (exception instanceof HttpMessageNotWritableException) {
            return this.handleHttpMessageNotWritable((HttpMessageNotWritableException)exception, headers, SharedErrorCode.INTERNAL_SERVER_ERROR, request);
        }
        if (exception instanceof MethodArgumentNotValidException) {
            return this.handleMethodArgumentNotValid((MethodArgumentNotValidException)exception, headers, SharedErrorCode.BAD_REQUEST, request);
        }
        if (exception instanceof MissingServletRequestPartException) {
            return this.handleMissingServletRequestPart((MissingServletRequestPartException)exception, headers, SharedErrorCode.BAD_REQUEST, request);
        }
        if (exception instanceof BindException) {
            return this.handleBindException((BindException)exception, headers, SharedErrorCode.BAD_REQUEST, request);
        }
        if (exception instanceof NoHandlerFoundException) {
            return this.handleNoHandlerFoundException((NoHandlerFoundException)exception, headers, SharedErrorCode.NOT_FOUND, request);
        }
        if (exception instanceof AccessDeniedException) {
            return this.handleAccessDeniedException((AccessDeniedException)exception, headers, SharedErrorCode.UNAUTHORIZED, request);
        }
        if (exception instanceof ApplicationException) {
            return this.handleApplicationException((ApplicationException)exception, headers, request);
        }
        this.logger.warn((Object)("Unknown exception type: " + exception.getClass().getName()));
        ErrorContainer errorContainer = this.convert2ErrorContainer(exception, SharedErrorCode.UNEXPECTED_ERROR, request);
        return this.handleExceptionInternal(exception, errorContainer, headers, SharedErrorCode.UNEXPECTED_ERROR.getHttpStatus(), request);
    }

    @ExceptionHandler(value={Throwable.class})
    public ResponseEntity<ErrorContainer> handleException(Throwable e, HttpServletRequest request) {
        HttpHeaders httpHeaders = new HttpHeaders();
        if (!(e instanceof Exception)) {
            ErrorContainer errorContainer = this.convert2ErrorContainer(e, SharedErrorCode.UNEXPECTED_ERROR, null, request);
            return new ResponseEntity((Object)errorContainer, (MultiValueMap)httpHeaders, SharedErrorCode.UNEXPECTED_ERROR.getHttpStatus());
        }
        Class<?> errorClazz = e.getClass();
        ErrorCode mappedErrorCode = ErrorCodes.getInstance().mappedErrorCode(errorClazz);
        while (mappedErrorCode == null && errorClazz.getSuperclass() != Object.class) {
            errorClazz = errorClazz.getSuperclass();
            mappedErrorCode = ErrorCodes.getInstance().mappedErrorCode(errorClazz);
        }
        if (mappedErrorCode != null) {
            return this.getResponseEntity(request, httpHeaders, (Exception)e, mappedErrorCode, new Object[0]);
        }
        return this.getResponseEntity(request, httpHeaders, (Exception)e, SharedErrorCode.UNEXPECTED_ERROR, new Object[0]);
    }

    protected ResponseEntity<Object> handleNoSuchRequestHandlingMethod(NoSuchRequestHandlingMethodException exception, HttpHeaders headers, ErrorCode errorCode, HttpServletRequest request) {
        PAGE_NOT_FOUND_LOGGER.warn((Object)exception.getMessage());
        ErrorContainer errorContainer = this.convert2ErrorContainer((Throwable)exception, errorCode, request);
        return this.handleExceptionInternal((Exception)exception, errorContainer, headers, errorCode.getHttpStatus(), request);
    }

    protected ResponseEntity<Object> handleHttpRequestMethodNotSupported(HttpRequestMethodNotSupportedException exception, HttpHeaders headers, ErrorCode errorCode, HttpServletRequest request) {
        PAGE_NOT_FOUND_LOGGER.warn((Object)exception.getMessage());
        Set supportedMethods = exception.getSupportedHttpMethods();
        if (!supportedMethods.isEmpty()) {
            headers.setAllow(supportedMethods);
        }
        ErrorContainer errorContainer = this.convert2ErrorContainer((Throwable)exception, errorCode, request);
        return this.handleExceptionInternal((Exception)exception, errorContainer, headers, errorCode.getHttpStatus(), request);
    }

    protected ResponseEntity<Object> handleHttpMediaTypeNotSupported(HttpMediaTypeNotSupportedException exception, HttpHeaders headers, ErrorCode errorCode, HttpServletRequest request) {
        List mediaTypes = exception.getSupportedMediaTypes();
        if (!CollectionUtils.isEmpty((Collection)mediaTypes)) {
            headers.setAccept(mediaTypes);
        }
        ErrorContainer errorContainer = this.convert2ErrorContainer((Throwable)exception, errorCode, request);
        return this.handleExceptionInternal((Exception)exception, errorContainer, headers, errorCode.getHttpStatus(), request);
    }

    protected ResponseEntity<Object> handleHttpMediaTypeNotAcceptable(HttpMediaTypeNotAcceptableException exception, HttpHeaders headers, ErrorCode errorCode, HttpServletRequest request) {
        ErrorContainer errorContainer = this.convert2ErrorContainer((Throwable)exception, errorCode, request);
        return this.handleExceptionInternal((Exception)exception, errorContainer, headers, errorCode.getHttpStatus(), request);
    }

    protected ResponseEntity<Object> handleMissingServletRequestParameter(MissingServletRequestParameterException exception, HttpHeaders headers, ErrorCode errorCode, HttpServletRequest request) {
        ErrorContainer errorContainer = this.convert2ErrorContainer((Throwable)exception, errorCode, request);
        return this.handleExceptionInternal((Exception)exception, errorContainer, headers, errorCode.getHttpStatus(), request);
    }

    protected ResponseEntity<Object> handleServletRequestBindingException(ServletRequestBindingException exception, HttpHeaders headers, ErrorCode errorCode, HttpServletRequest request) {
        ErrorContainer errorContainer = this.convert2ErrorContainer((Throwable)exception, errorCode, request);
        return this.handleExceptionInternal((Exception)exception, errorContainer, headers, errorCode.getHttpStatus(), request);
    }

    protected ResponseEntity<Object> handleConversionNotSupported(ConversionNotSupportedException exception, HttpHeaders headers, ErrorCode errorCode, HttpServletRequest request) {
        ErrorContainer errorContainer = this.convert2ErrorContainer((Throwable)exception, errorCode, request);
        return this.handleExceptionInternal((Exception)exception, errorContainer, headers, errorCode.getHttpStatus(), request);
    }

    protected ResponseEntity<Object> handleTypeMismatch(TypeMismatchException exception, HttpHeaders headers, ErrorCode errorCode, HttpServletRequest request) {
        ErrorContainer errorContainer = this.convert2ErrorContainer((Throwable)exception, errorCode, request);
        return this.handleExceptionInternal((Exception)exception, errorContainer, headers, errorCode.getHttpStatus(), request);
    }

    protected ResponseEntity<Object> handleHttpMessageNotReadable(HttpMessageNotReadableException exception, HttpHeaders headers, ErrorCode errorCode, HttpServletRequest request) {
        ErrorContainer errorContainer = this.convert2ErrorContainer((Throwable)exception, errorCode, request);
        return this.handleExceptionInternal((Exception)exception, errorContainer, headers, errorCode.getHttpStatus(), request);
    }

    protected ResponseEntity<Object> handleHttpMessageNotWritable(HttpMessageNotWritableException exception, HttpHeaders headers, ErrorCode errorCode, HttpServletRequest request) {
        ErrorContainer errorContainer = this.convert2ErrorContainer((Throwable)exception, errorCode, request);
        return this.handleExceptionInternal((Exception)exception, errorContainer, headers, errorCode.getHttpStatus(), request);
    }

    protected ResponseEntity<Object> handleMethodArgumentNotValid(MethodArgumentNotValidException exception, HttpHeaders headers, ErrorCode errorCode, HttpServletRequest request) {
        ErrorContainer error = new ErrorContainer();
        error.setErrorCode(SharedErrorCode.BAD_REQUEST);
        error.setErrorMessage(SharedErrorCode.BAD_REQUEST.getHttpStatus().getReasonPhrase());
        if (exception.getBindingResult() != null) {
            ArrayList<FormError> formErrorList = new ArrayList<FormError>();
            for (ObjectError objectError : exception.getBindingResult().getAllErrors()) {
                if (!(objectError instanceof FieldError)) continue;
                FormError formError = new FormError();
                formError.setField(((FieldError)objectError).getField());
                formError.setMessage(((FieldError)objectError).getDefaultMessage());
                formErrorList.add(formError);
            }
            error.setFormError(formErrorList);
        }
        if (this.isDeveloperEnabled() && exception.getStackTrace() != null) {
            error.setDeveloperMessage(Arrays.toString(exception.getStackTrace()));
        }
        error.setMoreInfo(exception.getMessage());
        return new ResponseEntity((Object)error, (MultiValueMap)headers, SharedErrorCode.BAD_REQUEST.getHttpStatus());
    }

    protected ResponseEntity<Object> handleMissingServletRequestPart(MissingServletRequestPartException exception, HttpHeaders headers, ErrorCode errorCode, HttpServletRequest request) {
        ErrorContainer errorContainer = this.convert2ErrorContainer((Throwable)exception, errorCode, request);
        return this.handleExceptionInternal((Exception)exception, errorContainer, headers, errorCode.getHttpStatus(), request);
    }

    protected ResponseEntity<Object> handleBindException(BindException exception, HttpHeaders headers, ErrorCode errorCode, HttpServletRequest request) {
        ErrorContainer error = new ErrorContainer();
        error.setErrorCode(SharedErrorCode.BAD_REQUEST);
        error.setErrorMessage(SharedErrorCode.BAD_REQUEST.getHttpStatus().getReasonPhrase());
        if (exception.getBindingResult() != null) {
            ArrayList<FormError> formErrorList = new ArrayList<FormError>();
            for (ObjectError objectError : exception.getBindingResult().getAllErrors()) {
                if (!(objectError instanceof FieldError)) continue;
                FormError formError = new FormError();
                formError.setField(((FieldError)objectError).getField());
                formError.setMessage(((FieldError)objectError).getDefaultMessage());
                formErrorList.add(formError);
            }
            error.setFormError(formErrorList);
        }
        if (this.isDeveloperEnabled() && exception.getStackTrace() != null) {
            error.setDeveloperMessage(Arrays.toString(exception.getStackTrace()));
        }
        error.setMoreInfo(exception.getMessage());
        return new ResponseEntity((Object)error, (MultiValueMap)headers, SharedErrorCode.BAD_REQUEST.getHttpStatus());
    }

    protected ResponseEntity<Object> handleNoHandlerFoundException(NoHandlerFoundException exception, HttpHeaders headers, ErrorCode errorCode, HttpServletRequest request) {
        ErrorContainer errorContainer = this.convert2ErrorContainer((Throwable)exception, errorCode, request);
        return this.handleExceptionInternal((Exception)exception, errorContainer, headers, errorCode.getHttpStatus(), request);
    }

    protected ResponseEntity<Object> handleAccessDeniedException(AccessDeniedException exception, HttpHeaders headers, ErrorCode errorCode, HttpServletRequest request) {
        ErrorContainer errorContainer = this.convert2ErrorContainer((Throwable)exception, errorCode, request);
        return this.handleExceptionInternal((Exception)exception, errorContainer, headers, errorCode.getHttpStatus(), request);
    }

    protected ResponseEntity<Object> handleApplicationException(ApplicationException exception, HttpHeaders headers, HttpServletRequest request) {
        ErrorCode errorCode = exception.getErrorCode();
        ErrorContainer errorContainer = this.convert2ErrorContainer(exception, errorCode, request);
        return this.handleExceptionInternal(exception, errorContainer, headers, errorCode.getHttpStatus(), request);
    }

    protected ResponseEntity<Object> handleExceptionInternal(Exception exception, ErrorContainer body, HttpHeaders headers, HttpStatus status, HttpServletRequest request) {
        if (HttpStatus.INTERNAL_SERVER_ERROR.equals((Object)status)) {
            request.setAttribute("javax.servlet.error.exception", (Object)exception);
        }
        return new ResponseEntity((Object)body, (MultiValueMap)headers, status);
    }

    protected ResponseEntity<ErrorContainer> getResponseEntity(HttpServletRequest request, HttpHeaders httpHeaders, Throwable throwable, ErrorCode errorCode) {
        return this.getResponseEntity(request, httpHeaders, throwable, errorCode, null);
    }

    protected ResponseEntity<ErrorContainer> getResponseEntity(HttpServletRequest request, HttpHeaders httpHeaders, Throwable throwable, ErrorCode errorCode, Object[] messageArguments) {
        ErrorContainer errorContainer = this.convert2ErrorContainer(throwable, errorCode, messageArguments, request);
        return new ResponseEntity((Object)errorContainer, (MultiValueMap)httpHeaders, errorCode.getHttpStatus());
    }

    protected String getErrorMessage(Throwable throwable, ErrorCode errorCode, HttpServletRequest request) {
        return this.getErrorMessage(throwable, errorCode, null, request);
    }

    protected String getErrorMessage(Throwable throwable, ErrorCode errorCode, Object[] messageArguments, HttpServletRequest request) {
        String result;
        if (!this.isI18nEnabled()) {
            String result2 = throwable.getMessage();
            if (StringUtils.isEmpty((Object)result2)) {
                result2 = errorCode.getHttpStatus().getReasonPhrase();
            }
            return result2;
        }
        Locale locale = Locale.getDefault();
        if (this.localeResolver != null) {
            locale = this.localeResolver.resolveLocale(request);
        }
        if (this.resourceBundle != null) {
            try {
                return this.resourceBundle.getMessage(errorCode.getCode(), messageArguments, errorCode.getHttpStatus().getReasonPhrase(), locale);
            }
            catch (Exception e) {
                this.logger.error((Object)e, (Throwable)e);
            }
        }
        if (StringUtils.isEmpty((Object)(result = throwable.getMessage()))) {
            result = errorCode.getHttpStatus().getReasonPhrase();
        }
        return result;
    }

    protected ErrorContainer convert2ErrorContainer(Throwable throwable, ErrorCode errorCode, HttpServletRequest request) {
        return this.convert2ErrorContainer(throwable, errorCode, null, request);
    }

    protected ErrorContainer convert2ErrorContainer(Throwable throwable, ErrorCode errorCode, Object[] messageArguments, HttpServletRequest request) {
        ErrorContainer result = new ErrorContainer();
        result.setErrorCode(errorCode);
        result.setErrorMessage(this.getErrorMessage(throwable, errorCode, messageArguments, request));
        if (this.isDeveloperEnabled()) {
            if (throwable.getStackTrace() != null) {
                result.setDeveloperMessage(Arrays.toString(throwable.getStackTrace()));
            }
            result.setMoreInfo(throwable.getMessage());
        }
        return result;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.isI18nEnabled() && this.getResourceBundle() == null) {
            throw new IllegalStateException("The i18n feature is enabled but the resource bundle is not injected.");
        }
    }
}

