/*
 * Decompiled with CFR 0.152.
 */
package in.clouthink.daas.we;

import in.clouthink.daas.we.DefaultErrorResolver;
import in.clouthink.daas.we.ErrorContext;
import in.clouthink.daas.we.ErrorResolver;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.springframework.http.ResponseEntity;

public class CompositeErrorResolver
implements ErrorResolver {
    private ErrorResolver defaultErrorResolver = new DefaultErrorResolver();
    private List<ErrorResolver> errorResolvers = new CopyOnWriteArrayList<ErrorResolver>();

    public CompositeErrorResolver add(ErrorResolver errorResolver) {
        this.errorResolvers.add(errorResolver);
        return this;
    }

    public CompositeErrorResolver remove(ErrorResolver errorResolver) {
        this.errorResolvers.remove(errorResolver);
        return this;
    }

    public CompositeErrorResolver setDefaultErrorResolver(ErrorResolver defaultErrorResolver) {
        this.defaultErrorResolver = defaultErrorResolver;
        return this;
    }

    public ResponseEntity resolve(ErrorContext errorContext) {
        for (ErrorResolver errorResolver : this.errorResolvers) {
            ResponseEntity result = errorResolver.resolve(errorContext);
            if (result == null) continue;
            return result;
        }
        return this.defaultErrorResolver.resolve(errorContext);
    }
}

