/*
 * Decompiled with CFR 0.152.
 */
package in.clouthink.daas.we;

import in.clouthink.daas.we.CompositeErrorResolver;
import in.clouthink.daas.we.DefaultErrorContextBuilder;
import in.clouthink.daas.we.DefaultErrorResponseHandler;
import in.clouthink.daas.we.ErrorContext;
import in.clouthink.daas.we.ErrorContextBuilder;
import in.clouthink.daas.we.ErrorResponseHandler;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.web.context.request.ServletWebRequest;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.method.support.HandlerMethodReturnValueHandler;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.method.annotation.ExceptionHandlerExceptionResolver;
import org.springframework.web.servlet.mvc.method.annotation.HttpEntityMethodProcessor;

public class CustomExceptionHandlerExceptionResolver
extends ExceptionHandlerExceptionResolver
implements InitializingBean {
    private boolean developerMode = true;
    private ErrorContextBuilder errorContextBuilder;
    private CompositeErrorResolver errorResolver = new CompositeErrorResolver();
    private ErrorResponseHandler errorResponseHandler;
    private HandlerMethodReturnValueHandler httpEntityReturnValueHandler;

    public CustomExceptionHandlerExceptionResolver(boolean developerMode) {
        this.getMessageConverters().add(new MappingJackson2HttpMessageConverter());
        this.developerMode = developerMode;
    }

    public ErrorContextBuilder getErrorContextBuilder() {
        return this.errorContextBuilder;
    }

    public CustomExceptionHandlerExceptionResolver setErrorContextBuilder(ErrorContextBuilder errorContextBuilder) {
        if (errorContextBuilder == null) {
            throw new NullPointerException();
        }
        this.errorContextBuilder = errorContextBuilder;
        return this;
    }

    public CompositeErrorResolver getErrorResolver() {
        return this.errorResolver;
    }

    public CustomExceptionHandlerExceptionResolver setErrorResolver(CompositeErrorResolver errorResolver) {
        if (errorResolver == null) {
            throw new NullPointerException();
        }
        this.errorResolver = errorResolver;
        return this;
    }

    public ErrorResponseHandler getErrorResponseHandler() {
        return this.errorResponseHandler;
    }

    public CustomExceptionHandlerExceptionResolver setErrorResponseHandler(ErrorResponseHandler errorResponseHandler) {
        if (errorResponseHandler == null) {
            throw new NullPointerException();
        }
        this.errorResponseHandler = errorResponseHandler;
        return this;
    }

    protected ModelAndView doResolveHandlerMethodException(HttpServletRequest request, HttpServletResponse response, HandlerMethod handlerMethod, Exception exception) {
        ErrorContext errorContext = this.errorContextBuilder.build(request, response, handlerMethod, exception);
        ResponseEntity errorResponseEntity = this.errorResolver.resolve(errorContext);
        if (errorResponseEntity == null) {
            return super.doResolveHandlerMethodException(request, response, handlerMethod, exception);
        }
        ServletWebRequest webRequest = new ServletWebRequest(request, response);
        webRequest.getResponse().setStatus(errorResponseEntity.getStatusCode().value());
        this.errorResponseHandler.handle(webRequest, errorResponseEntity);
        return new ModelAndView();
    }

    public void afterPropertiesSet() {
        if (this.errorContextBuilder == null) {
            this.errorContextBuilder = new DefaultErrorContextBuilder(this.developerMode);
        }
        if (this.httpEntityReturnValueHandler == null) {
            this.httpEntityReturnValueHandler = new HttpEntityMethodProcessor(this.getMessageConverters(), this.getContentNegotiationManager());
        }
        if (this.errorResponseHandler == null) {
            this.errorResponseHandler = new DefaultErrorResponseHandler(this.httpEntityReturnValueHandler);
        }
    }
}

