/*
 * Decompiled with CFR 0.152.
 */
package in.clouthink.daas.we;

import in.clouthink.daas.we.ErrorContext;
import in.clouthink.daas.we.ErrorResolver;
import in.clouthink.daas.we.ErrorResponse;
import in.clouthink.daas.we.FormError;
import in.clouthink.daas.we.HttpStatusProvider;
import in.clouthink.daas.we.ResponseEntityBuilder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.ConversionNotSupportedException;
import org.springframework.beans.TypeMismatchException;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.HttpMessageNotWritableException;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.validation.BindException;
import org.springframework.validation.FieldError;
import org.springframework.validation.ObjectError;
import org.springframework.web.HttpMediaTypeNotAcceptableException;
import org.springframework.web.HttpMediaTypeNotSupportedException;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.ServletRequestBindingException;
import org.springframework.web.multipart.support.MissingServletRequestPartException;
import org.springframework.web.servlet.NoHandlerFoundException;
import org.springframework.web.servlet.mvc.multiaction.NoSuchRequestHandlingMethodException;

public class DefaultErrorResolver
implements ErrorResolver {
    public static final String PAGE_NOT_FOUND_LOG_CATEGORY = "org.springframework.web.servlet.PageNotFound";
    protected static final Log pageNotFoundLogger = LogFactory.getLog((String)"org.springframework.web.servlet.PageNotFound");
    private static final Log logger = LogFactory.getLog(DefaultErrorResolver.class);

    public ResponseEntity resolve(ErrorContext errorContext) {
        Exception ex = errorContext.getException();
        Object handler = null;
        boolean developerMode = errorContext.isDeveloperMode();
        try {
            HttpStatus httpStatusEx;
            if (ex instanceof NoSuchRequestHandlingMethodException) {
                return this.handleNoSuchRequestHandlingMethod((NoSuchRequestHandlingMethodException)ex, handler, developerMode);
            }
            if (ex instanceof HttpRequestMethodNotSupportedException) {
                return this.handleHttpRequestMethodNotSupported((HttpRequestMethodNotSupportedException)ex, handler, developerMode);
            }
            if (ex instanceof HttpMediaTypeNotSupportedException) {
                return this.handleHttpMediaTypeNotSupported((HttpMediaTypeNotSupportedException)ex, handler, developerMode);
            }
            if (ex instanceof HttpMediaTypeNotAcceptableException) {
                return this.handleHttpMediaTypeNotAcceptable((HttpMediaTypeNotAcceptableException)ex, handler, developerMode);
            }
            if (ex instanceof MissingServletRequestParameterException) {
                return this.handleMissingServletRequestParameter((MissingServletRequestParameterException)ex, handler, developerMode);
            }
            if (ex instanceof ServletRequestBindingException) {
                return this.handleServletRequestBindingException((ServletRequestBindingException)ex, handler, developerMode);
            }
            if (ex instanceof ConversionNotSupportedException) {
                return this.handleConversionNotSupported((ConversionNotSupportedException)ex, handler, developerMode);
            }
            if (ex instanceof TypeMismatchException) {
                return this.handleTypeMismatch((TypeMismatchException)ex, handler, developerMode);
            }
            if (ex instanceof HttpMessageNotReadableException) {
                return this.handleHttpMessageNotReadable((HttpMessageNotReadableException)ex, handler, developerMode);
            }
            if (ex instanceof HttpMessageNotWritableException) {
                return this.handleHttpMessageNotWritable((HttpMessageNotWritableException)ex, handler, developerMode);
            }
            if (ex instanceof MethodArgumentNotValidException) {
                return this.handleMethodArgumentNotValidException((MethodArgumentNotValidException)ex, handler, developerMode);
            }
            if (ex instanceof MissingServletRequestPartException) {
                return this.handleMissingServletRequestPartException((MissingServletRequestPartException)ex, handler, developerMode);
            }
            if (ex instanceof BindException) {
                return this.handleBindException((BindException)ex, handler, developerMode);
            }
            if (ex instanceof NoHandlerFoundException) {
                return this.handleNoHandlerFoundException((NoHandlerFoundException)ex, handler, developerMode);
            }
            if (ex instanceof AccessDeniedException) {
                return this.handleAccessDeniedException((AccessDeniedException)ex, handler, developerMode);
            }
            HttpStatus httpStatus = HttpStatus.INTERNAL_SERVER_ERROR;
            if (ex instanceof HttpStatusProvider && (httpStatusEx = ((HttpStatusProvider)((Object)ex)).getHttpStatus()) != null) {
                httpStatus = httpStatusEx;
            }
            return ResponseEntityBuilder.getBuilder(developerMode).buildResponseEntity(ex, httpStatus);
        }
        catch (Exception handlerException) {
            logger.warn((Object)("Handling of [" + ex.getClass().getName() + "] resulted in Exception"), (Throwable)handlerException);
            return null;
        }
    }

    private ResponseEntity<ErrorResponse> handleAccessDeniedException(AccessDeniedException ex, Object handler, boolean developerMode) {
        return ResponseEntityBuilder.getBuilder(developerMode).buildResponseEntity((Exception)ex, HttpStatus.UNAUTHORIZED);
    }

    protected ResponseEntity<ErrorResponse> handleNoSuchRequestHandlingMethod(NoSuchRequestHandlingMethodException ex, Object handler, boolean developerMode) throws IOException {
        pageNotFoundLogger.warn((Object)ex.getMessage());
        return ResponseEntityBuilder.getBuilder(developerMode).buildResponseEntity((Exception)ex, HttpStatus.NOT_FOUND);
    }

    protected ResponseEntity<ErrorResponse> handleHttpRequestMethodNotSupported(HttpRequestMethodNotSupportedException ex, Object handler, boolean developerMode) throws IOException {
        pageNotFoundLogger.warn((Object)ex.getMessage());
        HttpHeaders headers = new HttpHeaders();
        Object[] supportedMethods = ex.getSupportedMethods();
        if (supportedMethods != null) {
            headers.set("Allow", StringUtils.arrayToDelimitedString((Object[])supportedMethods, (String)", "));
        }
        return ResponseEntityBuilder.getBuilder(developerMode).buildResponseEntity((Exception)ex, headers, HttpStatus.METHOD_NOT_ALLOWED);
    }

    protected ResponseEntity<ErrorResponse> handleHttpMediaTypeNotSupported(HttpMediaTypeNotSupportedException ex, Object handler, boolean developerMode) throws IOException {
        HttpHeaders headers = new HttpHeaders();
        List mediaTypes = ex.getSupportedMediaTypes();
        if (!CollectionUtils.isEmpty((Collection)mediaTypes)) {
            headers.set("Accept", MediaType.toString((Collection)mediaTypes));
        }
        return ResponseEntityBuilder.getBuilder(developerMode).buildResponseEntity((Exception)ex, headers, HttpStatus.UNSUPPORTED_MEDIA_TYPE);
    }

    protected ResponseEntity<ErrorResponse> handleHttpMediaTypeNotAcceptable(HttpMediaTypeNotAcceptableException ex, Object handler, boolean developerMode) throws IOException {
        return ResponseEntityBuilder.getBuilder(developerMode).buildResponseEntity((Exception)ex, HttpStatus.NOT_ACCEPTABLE);
    }

    protected ResponseEntity<ErrorResponse> handleMissingServletRequestParameter(MissingServletRequestParameterException ex, Object handler, boolean developerMode) throws IOException {
        return ResponseEntityBuilder.getBuilder(developerMode).buildResponseEntity((Exception)ex, HttpStatus.BAD_REQUEST);
    }

    protected ResponseEntity<ErrorResponse> handleServletRequestBindingException(ServletRequestBindingException ex, Object handler, boolean developerMode) throws IOException {
        return ResponseEntityBuilder.getBuilder(developerMode).buildResponseEntity((Exception)ex, HttpStatus.BAD_REQUEST);
    }

    protected ResponseEntity<ErrorResponse> handleConversionNotSupported(ConversionNotSupportedException ex, Object handler, boolean developerMode) throws IOException {
        return ResponseEntityBuilder.getBuilder(developerMode).buildResponseEntity((Exception)ex, HttpStatus.INTERNAL_SERVER_ERROR);
    }

    protected ResponseEntity<ErrorResponse> handleInternalServerError(ConversionNotSupportedException ex, Object handler, boolean developerMode) throws IOException {
        return ResponseEntityBuilder.getBuilder(developerMode).buildResponseEntity((Exception)ex, HttpStatus.INTERNAL_SERVER_ERROR);
    }

    protected ResponseEntity<ErrorResponse> handleTypeMismatch(TypeMismatchException ex, Object handler, boolean developerMode) throws IOException {
        return ResponseEntityBuilder.getBuilder(developerMode).buildResponseEntity((Exception)ex, HttpStatus.BAD_REQUEST);
    }

    protected ResponseEntity<ErrorResponse> handleHttpMessageNotReadable(HttpMessageNotReadableException ex, Object handler, boolean developerMode) throws IOException {
        return ResponseEntityBuilder.getBuilder(developerMode).buildResponseEntity((Exception)ex, HttpStatus.BAD_REQUEST);
    }

    protected ResponseEntity<ErrorResponse> handleHttpMessageNotWritable(HttpMessageNotWritableException ex, Object handler, boolean developerMode) throws IOException {
        return ResponseEntityBuilder.getBuilder(developerMode).buildResponseEntity((Exception)ex, HttpStatus.INTERNAL_SERVER_ERROR);
    }

    protected ResponseEntity<ErrorResponse> handleMethodArgumentNotValidException(MethodArgumentNotValidException ex, Object handler, boolean developerMode) throws IOException {
        if (ex.getBindingResult() != null) {
            ArrayList<FormError> formErrorList = new ArrayList<FormError>();
            for (ObjectError objectError : ex.getBindingResult().getAllErrors()) {
                if (!(objectError instanceof FieldError)) continue;
                FormError formError = new FormError();
                formError.setField(((FieldError)objectError).getField());
                formError.setMessage(((FieldError)objectError).getDefaultMessage());
                formErrorList.add(formError);
            }
            return ResponseEntityBuilder.getBuilder(developerMode).buildResponseEntity((Exception)ex, HttpStatus.BAD_REQUEST.getReasonPhrase(), HttpStatus.BAD_REQUEST, formErrorList);
        }
        return ResponseEntityBuilder.getBuilder(developerMode).buildResponseEntity((Exception)ex, HttpStatus.BAD_REQUEST.getReasonPhrase(), HttpStatus.BAD_REQUEST);
    }

    protected ResponseEntity<ErrorResponse> handleBindException(BindException ex, Object handler, boolean developerMode) throws IOException {
        if (ex.getBindingResult() != null) {
            ArrayList<FormError> formErrorList = new ArrayList<FormError>();
            for (ObjectError objectError : ex.getBindingResult().getAllErrors()) {
                if (!(objectError instanceof FieldError)) continue;
                FormError formError = new FormError();
                formError.setField(((FieldError)objectError).getField());
                formError.setMessage(((FieldError)objectError).getDefaultMessage());
                formErrorList.add(formError);
            }
            return ResponseEntityBuilder.getBuilder(developerMode).buildResponseEntity((Exception)ex, HttpStatus.BAD_REQUEST.getReasonPhrase(), HttpStatus.BAD_REQUEST, formErrorList);
        }
        return ResponseEntityBuilder.getBuilder(developerMode).buildResponseEntity((Exception)ex, HttpStatus.BAD_REQUEST.getReasonPhrase(), HttpStatus.BAD_REQUEST);
    }

    protected ResponseEntity<ErrorResponse> handleMissingServletRequestPartException(MissingServletRequestPartException ex, Object handler, boolean developerMode) throws IOException {
        return ResponseEntityBuilder.getBuilder(developerMode).buildResponseEntity((Exception)ex, HttpStatus.BAD_REQUEST);
    }

    protected ResponseEntity<ErrorResponse> handleNoHandlerFoundException(NoHandlerFoundException ex, Object handler, boolean developerMode) throws IOException {
        return ResponseEntityBuilder.getBuilder(developerMode).buildResponseEntity((Exception)ex, HttpStatus.NOT_FOUND);
    }
}

