/*
 * Decompiled with CFR 0.152.
 */
package in.clouthink.daas.we;

import in.clouthink.daas.we.ErrorResponseHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.context.request.ServletWebRequest;
import org.springframework.web.method.support.HandlerMethodReturnValueHandler;
import org.springframework.web.method.support.ModelAndViewContainer;

public class DefaultErrorResponseHandler
implements ErrorResponseHandler<ResponseEntity> {
    private static final Log logger = LogFactory.getLog(DefaultErrorResponseHandler.class);
    private HandlerMethodReturnValueHandler httpEntityReturnValueHandler;

    public DefaultErrorResponseHandler(HandlerMethodReturnValueHandler httpEntityReturnValueHandler) {
        this.httpEntityReturnValueHandler = httpEntityReturnValueHandler;
    }

    @Override
    public void handle(ServletWebRequest webRequest, ResponseEntity<ResponseEntity> errorResponseEntity) {
        block2: {
            try {
                webRequest.getResponse().setStatus(errorResponseEntity.getStatusCode().value());
                this.httpEntityReturnValueHandler.handleReturnValue(errorResponseEntity, null, new ModelAndViewContainer(), (NativeWebRequest)webRequest);
            }
            catch (Exception ex) {
                if (!logger.isTraceEnabled()) break block2;
                logger.trace((Object)this.getReturnValueHandlingErrorMessage("Error handling return value", errorResponseEntity), (Throwable)ex);
            }
        }
    }

    private String getReturnValueHandlingErrorMessage(String message, Object returnValue) {
        StringBuilder sb = new StringBuilder(message);
        if (returnValue != null) {
            sb.append(" [type=" + returnValue.getClass().getName() + "] ");
        }
        sb.append("[value=" + returnValue + "]");
        return sb.toString();
    }
}

