/*
 * Decompiled with CFR 0.152.
 */
package in.clouthink.daas.we;

import in.clouthink.daas.we.ErrorCodeProvider;
import in.clouthink.daas.we.ErrorContext;
import in.clouthink.daas.we.ErrorResolver;
import in.clouthink.daas.we.HttpStatusProvider;
import in.clouthink.daas.we.ResponseEntityBuilder;
import in.clouthink.daas.we.ValueProvider;
import in.clouthink.daas.we.annotation.ErrorMapping;
import in.clouthink.daas.we.annotation.ErrorMappings;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.method.HandlerMethod;

public class ErrorMappingResolver
implements ErrorResolver {
    private ConcurrentMap<Method, ErrorMappingCache> methodErrorMappingsCache = new ConcurrentHashMap<Method, ErrorMappingCache>();

    public ResponseEntity resolve(ErrorContext errorContext) {
        HandlerMethod handlerMethod = errorContext.getHandlerMethod();
        Exception exception = errorContext.getException();
        boolean developerMode = errorContext.isDeveloperMode();
        if (this.matched(handlerMethod.getMethod()) && exception instanceof ErrorCodeProvider) {
            String errorCode = ((ErrorCodeProvider)((Object)exception)).getErrorCode();
            ErrorMappingCache errorMappingCache = this.resolveErrorMappingCache(handlerMethod);
            HttpStatus httpStatus = (HttpStatus)errorMappingCache.get(errorCode);
            if (httpStatus == null) {
                httpStatus = HttpStatus.INTERNAL_SERVER_ERROR;
            }
            return ResponseEntityBuilder.getBuilder(developerMode).buildResponseEntity(exception, httpStatus);
        }
        return null;
    }

    private ErrorMappingCache resolveErrorMappingCache(HandlerMethod handlerMethod) {
        ErrorMapping[] errorMappingArray;
        Method method = handlerMethod.getMethod();
        ErrorMappingCache result = (ErrorMappingCache)this.methodErrorMappingsCache.get(method);
        if (result != null) {
            return result;
        }
        result = new ErrorMappingCache();
        ErrorMappings errorMappings = method.getAnnotation(ErrorMappings.class);
        HttpStatus defaultHttpStatus = errorMappings.httpStatus();
        for (Class<? extends Enum<?>> enumClazz : errorMappings.errorType()) {
            List<Enum<?>> enums = this.resolveEnums(enumClazz);
            for (Enum<?> enumRef : enums) {
                if (enumRef instanceof ErrorCodeProvider) {
                    result.put(((ErrorCodeProvider)((Object)enumRef)).getErrorCode(), this.resolveHttpStatus(enumRef, defaultHttpStatus));
                    continue;
                }
                if (enumRef instanceof ValueProvider) {
                    result.put(((ValueProvider)((Object)enumRef)).getValue(), this.resolveHttpStatus(enumRef, defaultHttpStatus));
                    continue;
                }
                result.put(enumRef.name(), this.resolveHttpStatus(enumRef, defaultHttpStatus));
            }
        }
        for (ErrorMapping errorMapping : errorMappingArray = errorMappings.value()) {
            result.put(errorMapping.errorCode(), errorMapping.httpStatus());
        }
        this.methodErrorMappingsCache.put(method, result);
        return result;
    }

    private HttpStatus resolveHttpStatus(Enum<?> enumRef, HttpStatus defaultHttpStatus) {
        HttpStatus httpStatus;
        HttpStatus result = defaultHttpStatus;
        if (enumRef instanceof HttpStatusProvider && (httpStatus = ((HttpStatusProvider)((Object)enumRef)).getHttpStatus()) != null) {
            result = httpStatus;
        }
        return result;
    }

    private List<Enum<?>> resolveEnums(Class<? extends Enum> enumClazz) {
        ArrayList result = new ArrayList();
        for (Field field : enumClazz.getDeclaredFields()) {
            if (!field.isEnumConstant()) continue;
            result.add(Enum.valueOf(enumClazz, field.getName()));
        }
        return result;
    }

    private boolean matched(Method method) {
        return method.isAnnotationPresent(ErrorMappings.class);
    }

    private static class ErrorMappingCache
    extends ConcurrentHashMap<String, HttpStatus> {
        public ErrorMappingCache(int initialCapacity, float loadFactor, int concurrencyLevel) {
            super(initialCapacity, loadFactor, concurrencyLevel);
        }

        public ErrorMappingCache(int initialCapacity, float loadFactor) {
            super(initialCapacity, loadFactor);
        }

        public ErrorMappingCache(int initialCapacity) {
            super(initialCapacity);
        }

        public ErrorMappingCache() {
        }

        public ErrorMappingCache(Map<? extends String, ? extends HttpStatus> m) {
            super(m);
        }
    }
}

